package gov.va.med.nhin.adapter.docquery;

import javax.ejb.EJB;
import javax.ejb.*;
import javax.jws.WebService;
import javax.xml.ws.BindingType;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.hhs.fha.nhinc.adapterdocquery.AdapterDocQueryPortType;
import gov.hhs.fha.nhinc.adapterpolicyengine.AdapterPolicyEnginePortType;
import gov.hhs.fha.nhinc.common.eventcommon.AdhocQueryRequestEventType;
import gov.hhs.fha.nhinc.common.eventcommon.AdhocQueryRequestMessageType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyRequestType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyResponseType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.RespondingGatewayCrossGatewayQueryRequestType;
import gov.hhs.fha.nhinc.nhinclib.NhincConstants;
import gov.hhs.fha.nhinc.transform.policy.PolicyEngineTransformer;
import gov.va.med.nhin.adapter.errors.CreateErrorInterface;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManagerLocal;
import gov.va.med.nhin.adapter.facilitymanager.OperationOnOff;
import gov.va.med.nhin.adapter.logging.CheckPolicy;
import gov.va.med.nhin.adapter.logging.ErrorMessage;
import gov.va.med.nhin.adapter.logging.EventAuditingFactory;
import gov.va.med.nhin.adapter.logging.EventAuditingFactoryImpl;
import gov.va.med.nhin.adapter.logging.LogConstants.AuditingEvent;
import gov.va.med.nhin.adapter.logging.MaintLog;
import gov.va.med.nhin.adapter.policyengine.AdapterPolicyEnginePortTypeLocal;
import gov.va.med.nhin.adapter.sensitiveInfo.SensitiveInfoManager;
import gov.va.med.nhin.adapter.sensitiveInfo.SensitiveInfoManagerLocal;
import javax.jws.HandlerChain;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.RegistryObjectListType;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryError;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryErrorList;
import org.hl7.fhir.dstu3.model.AuditEvent;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "AdapterDocQuerySoap12",
            //wsdlLocation = "META-INF/wsdl/AdapterDocQuerySoap12.wsdl",
            portName = "AdapterDocQueryPortSoap",
            endpointInterface = "gov.hhs.fha.nhinc.adapterdocquery.AdapterDocQueryPortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:adapterdocquery")
@BindingType(value = javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING)
@HandlerChain(file="SOAPHandlerChain.xml")
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "AdapterDocQuery")
public class AdapterDocQuery implements AdapterDocQueryPortTypeLocal
{
    private static final Logger logger = LoggerFactory.getLogger(AdapterDocQuery.class.getName());

    private AdapterDocQueryPortType docQuery;
    private AdapterPolicyEnginePortType policyEngine;
    private FacilityManager facilityManager;
    private CreateErrorInterface errorResponse;
    private SensitiveInfoManager sensitiveInfoBean;

    @EJB(beanInterface = CreateErrorInterface.class, beanName = "CreateResponseError")
    public void setErrorResponse(CreateErrorInterface errorResponse)
    {
        this.errorResponse = errorResponse;
    }

    @EJB(beanInterface = AdapterDocQueryPortTypeLocal.class, beanName = "DocQuery")
    public void setDocQuery(AdapterDocQueryPortType docQuery)
    {
        this.docQuery = docQuery;
    }

    @EJB(beanInterface = AdapterPolicyEnginePortTypeLocal.class, beanName = "AdapterPolicyEngine")
    public void setPolicyEngine(AdapterPolicyEnginePortType policyEngine)
    {
        this.policyEngine = policyEngine;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = SensitiveInfoManagerLocal.class, beanName = "SensitiveInfoBean")
    public void setSensitiveInfoBean(SensitiveInfoManager sensitiveInfoBean)
    {
        this.sensitiveInfoBean = sensitiveInfoBean;
    }

		@Override
    public AdhocQueryResponse respondingGatewayCrossGatewayQuery(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
				EventAuditingFactory<AuditEvent> afac
						= EventAuditingFactoryImpl.getFactory( AuditEvent.class );
				afac.debug( afac.newEvent( respondingGatewayCrossGatewayQueryRequest.getAssertion(),
						AuditingEvent.QDIN_BEGIN, getClass() ) );

        String partnerCommunityId = respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity().getHomeCommunityId();

        // CCR 177986 - logger updates
        logger.info("Entering Document Query <2010 Spec> Call  - The partner Homecommunity ID  is {}", partnerCommunityId);

        AdhocQueryResponse ret;

        try {
            if (facilityManager.isPartnerAllowed(partnerCommunityId, OperationOnOff.ONBOARD)) {
							afac.debug( afac.messaging().partnerauth( AuditingEvent.QDIN_PARTNERAUTH,
									getClass(), partnerCommunityId ) );

                if (facilityManager.isPartnerAllowed(partnerCommunityId, OperationOnOff.IN_DQ)) {
                    if (checkPolicy(respondingGatewayCrossGatewayQueryRequest)) {
												afac.info( AuditingEvent.QDIN_GATHER, getClass() );
                        ret = docQuery.respondingGatewayCrossGatewayQuery(respondingGatewayCrossGatewayQueryRequest);
                    }
                    else {
                        ret = createAdhocQueryResponseEmpty(respondingGatewayCrossGatewayQueryRequest);
                    }
                }
                else {
                    ret = errorResponse.createAdhocQueryResponseError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_DISABLED);
                    MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_DISABLED, logger);
                }
            }
            else {
                ret = errorResponse.createAdhocQueryResponseError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_NOT_A_PARTNER);
                MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_NOT_A_PARTNER, logger);
            }
        }
        catch (Throwable t) {
            String hcid;
            String hcidName;
            if (respondingGatewayCrossGatewayQueryRequest.getAssertion() != null && respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity() != null) {
                hcid = respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity().getHomeCommunityId();
                hcidName = respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity().getName();
            }
            else {
                hcid = "N/A";
                hcidName = "Not Available";
            }

            // CCR 177986 - parameterized logging
            logger.warn("Error processing DocQuery from {} {} - {}", hcid, hcidName, t.getMessage());
            logger.warn("Error processing DocQuery {}", t);

            ret = createAdhocQueryResponseError(respondingGatewayCrossGatewayQueryRequest);
            MaintLog.queryError(respondingGatewayCrossGatewayQueryRequest, ErrorMessage.IN_DQ_UKNOWN, t.getMessage(), logger);
        }

				AuditEvent ae2 = afac.newEvent( respondingGatewayCrossGatewayQueryRequest.getAssertion(),
						AuditingEvent.QDIN_END, getClass() );
				afac.debug( ae2 );
        return ret;
    }

    private boolean checkPolicy(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
				EventAuditingFactory<AuditEvent> afac
						= EventAuditingFactoryImpl.getFactory( AuditEvent.class );
				afac.debug( AuditingEvent.QDIN_PATIENTSHARE, getClass() );

        AdhocQueryRequestMessageType adhocQueryRequestMessage = new AdhocQueryRequestMessageType();
        adhocQueryRequestMessage.setAdhocQueryRequest(respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest());
        adhocQueryRequestMessage.setAssertion(respondingGatewayCrossGatewayQueryRequest.getAssertion());

        AdhocQueryRequestEventType policyCheckReq = new AdhocQueryRequestEventType();
        policyCheckReq.setDirection(NhincConstants.POLICYENGINE_INBOUND_DIRECTION);
        policyCheckReq.setMessage(adhocQueryRequestMessage);

        PolicyEngineTransformer policyEngineTransformer = new PolicyEngineTransformer();
        CheckPolicyRequestType checkPolicyRequest = policyEngineTransformer.transformAdhocQueryToCheckPolicy(policyCheckReq);

        CheckPolicyResponseType checkPolicyResponse = policyEngine.checkPolicy(checkPolicyRequest);
        sensitiveInfoBean.checkPolicyAndAddSlot(respondingGatewayCrossGatewayQueryRequest, checkPolicyResponse);
        return CheckPolicy.checkPolicy(checkPolicyRequest, checkPolicyResponse);
    }

    private AdhocQueryResponse createAdhocQueryResponseEmpty(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
        oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory objFactory = new oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory();
        AdhocQueryResponse ret = objFactory.createAdhocQueryResponse();
        AdhocQueryRequest fromAdhocQueryRequest = respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest();
        ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success");
        ret.setRequestId(fromAdhocQueryRequest.getId());
        ret.setRegistryObjectList(new RegistryObjectListType());
        return ret;
    }

    private AdhocQueryResponse createAdhocQueryResponseError(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
        oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory objFactory = new oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory();
        AdhocQueryResponse ret = objFactory.createAdhocQueryResponse();
        AdhocQueryRequest fromAdhocQueryRequest = respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest();
        ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure");
        ret.setRegistryErrorList(createDefaultRegistryErrorList());
        ret.setRequestId(fromAdhocQueryRequest.getId());
        ret.setRegistryObjectList(new RegistryObjectListType());
        return ret;
    }

    private RegistryErrorList createDefaultRegistryErrorList()
    {
        RegistryErrorList ret = new RegistryErrorList();
        ret.getRegistryError().add(createDefaultRegistryError());
        ret.setHighestSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        return ret;
    }

    private RegistryError createDefaultRegistryError()
    {
        RegistryError ret = new RegistryError();
        ret.setErrorCode("XDSRegistryError");
        ret.setCodeContext("Internal Registry/Repository Error");
        ret.setSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        ret.setLocation(getHomeFacility().getFullHomeCommunityId());
        return ret;
    }

    private Facility getHomeFacility()
    {
        return facilityManager.getFacilityByFacilityNumber("VA");
    }
}
