package gov.va.med.nhin.adapter.adapterxdr;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.PersonNameType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.AdapterProvideAndRegisterDocumentSetRequestType;

import javax.ejb.*;
import javax.jws.WebService;
import javax.xml.ws.BindingType;
import javax.xml.ws.soap.SOAPBinding;

import gov.hhs.fha.nhinc.nhinccomponentpatientcorrelation.PatientCorrelationPortType;
import gov.hhs.fha.nhinc.transform.subdisc.HL7PRPA201309Transforms;
import gov.va.med.nhin.adapter.audit.Audit;
import gov.va.med.nhin.adapter.audit.AuditManager;
import gov.va.med.nhin.adapter.audit.AuditManagerLocal;
import gov.va.med.nhin.adapter.documentrepository.Document;
import gov.va.med.nhin.adapter.documentrepository.DocumentRepository;
import gov.va.med.nhin.adapter.documentrepository.DocumentRepositoryLocal;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManagerLocal;
import gov.va.med.nhin.adapter.logging.EventAuditingFactory;
import gov.va.med.nhin.adapter.logging.EventAuditingFactoryImpl;
import gov.va.med.nhin.adapter.logging.LogConstants;
import gov.va.med.nhin.adapter.logging.LogConstants.AuditingEvent;
import gov.va.med.nhin.adapter.patientcorrelation.PatientCorrelationPortTypeLocal;
import gov.va.med.nhin.adapter.patientcorrelation.parsers.helpers.Configuration;
import gov.va.med.nhin.adapter.patientdiscovery.VapConsentManagementPortTypeLocal;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;
import gov.va.med.nhin.adapter.utils.AuditUtil;
import gov.va.med.nhin.adapter.utils.LogUtil;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.das.DasDAO;
import gov.va.med.nhin.adapter.utils.das.DasDAOHttpImpl;
import gov.va.med.nhin.adapter.utils.das.DasException;
import gov.va.med.nhin.adapter.utils.das.DasOperationSendImmunizationDataRequest;
import gov.va.med.nhin.adapter.utils.das.DasOperationSendImmunizationDataResponse;
import gov.va.nvap.privacy.OrganizationTrustedSourceRequestType;
import gov.va.nvap.privacy.OrganizationTrustedSourceResponseType;
import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.jws.HandlerChain;
import javax.xml.bind.JAXBElement;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExternalIdentifierType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExtrinsicObjectType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.IdentifiableType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.RegistryObjectListType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.SlotListType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.SlotType1;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ValueListType;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryError;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryErrorList;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryResponseType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.RegistryPackageType;
import org.hl7.fhir.dstu3.model.AuditEvent;
import org.hl7.v3.II;
import org.hl7.v3.RetrievePatientCorrelationsRequestType;
import org.hl7.v3.RetrievePatientCorrelationsResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import privacy.service.nvap.va.gov.ConsentManagementPortType;
import privacy.service.nvap.va.gov.ConsentManagementServiceFaultMessage;

/**
 * This Web Service implements Document Submission functionality provided by
 * CONNECT Gateway.
 *
 * @author KazeninP
 */
@WebService(serviceName = "AdapterXDR_Service",
            endpointInterface = "gov.hhs.fha.nhinc.adapterxdr.AdapterXDRPortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:adapterxdr",
            portName = "AdapterXDR_Port"/*,
            wsdlLocation = "META-INF/wsdl/AdapterXDR.wsdl"*/)
@BindingType(SOAPBinding.SOAP12HTTP_BINDING)
@HandlerChain(file="SOAPHandlerChain.xml")
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "AdapterXDR")
public class AdapterXDR implements AdapterXDRPortTypeLocal
{
    public static final Logger logger = LoggerFactory.getLogger(AdapterXDR.class.getName());

    static private final String XDS_RETRIEVE_RESPONSE_STATUS_FAILURE = "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure";
    static private final String XDS_RETRIEVE_RESPONSE_STATUS_SUCCESS = "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success";

    private PropertyLookup propertyLookup;
    private FacilityManager facilityManager;
    private AuditManager auditManager;
    private PatientCorrelationPortType adapterPatientCorrelation;
    private DocumentRepository documentRepository;
    private ConsentManagementPortType vapConsentManagement;

    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = AuditManagerLocal.class, beanName = "AuditManager")
    public void setAuditManager(AuditManager auditManager)
    {
        this.auditManager = auditManager;
    }

    @EJB(beanInterface = PatientCorrelationPortTypeLocal.class, beanName = "AdapterPatientCorrelation")
    public void setAdapterPatientCorrelation(PatientCorrelationPortType adapterPatientCorrelation)
    {
        this.adapterPatientCorrelation = adapterPatientCorrelation;
    }

    @EJB(beanInterface = DocumentRepositoryLocal.class, beanName = "DocumentRepository")
    public void setDocumentRepository(DocumentRepository documentRepository)
    {
        this.documentRepository = documentRepository;
    }

    @EJB(beanInterface = VapConsentManagementPortTypeLocal.class, beanName = "VapConsentManagement")
    public void setVapConsentManagement(ConsentManagementPortType vapConsentManagement)
    {
        this.vapConsentManagement = vapConsentManagement;
    }

    /*
     * This method implements provideAndRegisterDocumentSetb operation defined
     * in the AdapterXDR.wsdl.
     *
     * @param request contains ICN, HomeCommunityId and C32 clinical document
     *
     * @return response contains either VLER BsonDocId in case of success or
     * error description in case of failure
     */
		@Override
    public RegistryResponseType provideAndRegisterDocumentSetb(AdapterProvideAndRegisterDocumentSetRequestType request)
    {
				EventAuditingFactory<AuditEvent> afac
						= EventAuditingFactoryImpl.getFactory( AuditEvent.class );
				afac.newEvent( request.getAssertion(),
						LogConstants.AuditingEvent.SUBMITIN_BEGIN, getClass() );

        // CCR 177986- logger update
        logger.debug("provideAndRegisterDocumentSetb() invoked");

        RegistryResponseType ret;

        String errorMsg;

        ProvideAndRegisterDocumentSetRequestType body = request.getProvideAndRegisterDocumentSetRequest();

        logger.debug("body {}", body);

        AssertionType assertion = request.getAssertion();

        String requestId = getRequestId(body);

        logger.debug("request id {}", requestId);

        // retrieve C32 doc from the message
        byte[] c32document = getC32Document(body);

        // CCR 177986
        logger.debug("c32document {}", c32document);

        if(NullChecker.isNullOrEmpty(c32document)) {

            errorMsg = "C32 Clinical Document is missing, request Id = " + requestId;
            ret = createErrorRegistryResponseType("XDSMissingDocument", errorMsg, null);
            ret.setRequestId(requestId);

            // CCR 177986
            logger.error("Error while creating registry respose {}", errorMsg);
						afac.debug( AuditingEvent.SUBMITIN_END, getClass() );
            return ret;
        }

        // CCR 177986
        logger.debug("C32 Clinical Document content {} :\n", new String(c32document));

        // retrieve ICN from the message
        String icn = getICN(body);
        logger.debug("icn {}", icn);
        if(NullChecker.isNullOrEmpty(icn)) {
            errorMsg = "ICN is missing, request Id = " + requestId;
            ret = createErrorRegistryResponseType("XDSUnknownPatientId", errorMsg, null);
            ret.setRequestId(requestId);

            logger.error(errorMsg);
						afac.debug( AuditingEvent.SUBMITIN_END, getClass() );
            return ret;
        }

        // CCR 177986
        logger.debug("Patient Unique Id (ICN) {} = ", icn);

        // retrieve Home Community Id from the message
        String homeCommunityId = getHomeCommunityId(assertion);
        if(NullChecker.isNullOrEmpty(homeCommunityId)) {
            errorMsg = "Home Community Id is missing, request Id = " + requestId + ", ICN = " + icn;
            ret = createErrorRegistryResponseType("XDSMissingHomeCommunityId", errorMsg, null);
            ret.setRequestId(requestId);

            logger.error(errorMsg);

            return ret;
        }

        // CCR 177986 - parameterized logging
        logger.info("Home Community Id {} = ", homeCommunityId);

        // get home facility of the requestor
        Facility homeFacility = getHomeFacility(homeCommunityId);
        if(NullChecker.isNullOrEmpty(homeFacility)) {
            errorMsg = "Home Community Id " + homeCommunityId + " is invalid, request Id = " + requestId + ", ICN = " + icn;
            ret = createErrorRegistryResponseType("XDSMissingHomeCommunityId", errorMsg, null);
            ret.setRequestId(requestId);

            // CCR 177986 - parameterized logging
            logger.error("ICN is not correlated to facility");
            logger.error(errorMsg + "{}");
						afac.debug( AuditingEvent.SUBMITIN_END, getClass() );
            return ret;
        }

        //check Policy?
        OrganizationTrustedSourceRequestType trustReq = new OrganizationTrustedSourceRequestType();
        trustReq.setOrganizationId(homeCommunityId);
        try {
            OrganizationTrustedSourceResponseType trustRes = vapConsentManagement.getIsOrganizationTrustedSource(trustReq);
						afac.debug( afac.messaging().partnerauth( AuditingEvent.SUBMITIN_PARTNERAUTH,
								getClass(), homeCommunityId ) );
						if(NullChecker.isNotNullOrEmpty(trustRes))
            {
              if(!trustRes.isIsTrusted()) {
                 logger.info("Request from Home Community Id: " + homeCommunityId + " failed organization trusted policy check, request Id = " + requestId + ", ICN = " +icn);

                 errorMsg = "Request failed a policy check.";
                 ret = createErrorRegistryResponseType("XDSRepositoryError", errorMsg, null);
                 ret.setRequestId(requestId);
								 afac.debug( AuditingEvent.SUBMITIN_END, getClass() );
                 return ret;
               }
            }
        } catch (ConsentManagementServiceFaultMessage ex) {
            logger.error("Error during is organization trusted policy check.", ex);

            errorMsg = "Request failed a policy check.";
            ret = createErrorRegistryResponseType("XDSRepositoryError", errorMsg, null);
            ret.setRequestId(requestId);
						afac.debug( AuditingEvent.SUBMITIN_END, getClass() );
            return ret;
        }

        String facilityNumber = homeFacility.getFacilityNumber();
        logger.debug("Facility Number {} = ", facilityNumber);

        // check if ICN is correlated to Home Facility Id
        II patientId = new II();
        patientId.setRoot(Configuration.getMyCommunityId()); // VA OID
        patientId.setExtension(icn);

        RetrievePatientCorrelationsRequestType patientCorrelationsRequest = new RetrievePatientCorrelationsRequestType();
        patientCorrelationsRequest.setPRPAIN201309UV02(HL7PRPA201309Transforms.createPRPA201309(patientId.getRoot(), patientId.getExtension()));

        patientCorrelationsRequest.setAssertion(assertion);

        RetrievePatientCorrelationsResponseType patientCorrelations;

        try {
            patientCorrelations = adapterPatientCorrelation.retrievePatientCorrelations(patientCorrelationsRequest);
        }
        catch(Exception e) {
            errorMsg = "Error trying to correlate patient, Home Community Id " + homeCommunityId + ", request Id = " + requestId + ", ICN = " + icn + ", exception = " + e.getMessage();
            ret = createErrorRegistryResponseType("XDSRegistryError", errorMsg, homeFacility);
            ret.setRequestId(requestId);

            // CCR 177986 - parameterized logging
            logger.error(errorMsg + "{}");
						afac.debug( AuditingEvent.SUBMITIN_END, getClass() );
            return ret;
        }

        if(patientCorrelations == null || patientCorrelations.getPRPAIN201310UV02() == null) {
            errorMsg = "ICN is unknown to VA, Home Community Id " + homeCommunityId + ", request Id = " + requestId + ", ICN = " + icn;
            ret = createErrorRegistryResponseType("XDSUnknownPatientId", errorMsg, homeFacility);
            ret.setRequestId(requestId);

            // CCR 177986 - parameterized logging
            logger.error(errorMsg + "{}");
						afac.debug( AuditingEvent.SUBMITIN_END, getClass() );
            return ret;
        }

        List<II> correlatedPatientIds = patientCorrelations.getPRPAIN201310UV02().getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient().getId();

        if(NullChecker.isNullOrEmpty(correlatedPatientIds) || correlatedPatientIds.size() == 0) {
            errorMsg = "ICN is unknown to VA, Home Community Id " + homeCommunityId + ", request Id = " + requestId + ", ICN = " + icn;
            ret = createErrorRegistryResponseType("XDSUnknownPatientId", errorMsg, homeFacility);
            ret.setRequestId(requestId);

            // CCR 177986 - parameterized logging
            logger.error(errorMsg + "{}");
						afac.debug( AuditingEvent.SUBMITIN_END, getClass() );
            return ret;
        }

        boolean correlated = false;
        String shortCommunityId;

        if(homeCommunityId.startsWith("urn:oid:")) {
            shortCommunityId = homeCommunityId.substring(8);
        } else {
            shortCommunityId = homeCommunityId;
        }

        for(II correlatedPatientId : correlatedPatientIds) {

            if(shortCommunityId.equalsIgnoreCase(correlatedPatientId.getRoot())) {
                    correlated = true;
                    break;
            }
        }

        if(!correlated) {
            errorMsg = "ICN is not correlated to " + facilityNumber + ", Home Community Id " + homeCommunityId + ", request Id = " + requestId + ", ICN = " + icn;
            ret = createErrorRegistryResponseType("XDSUnknownPatientId", errorMsg, homeFacility);
            ret.setRequestId(requestId);

            // CCR 177986 - parameterized logging
            logger.error(LogUtil.cleanLogMessage(errorMsg) + "{}");
						afac.debug( AuditingEvent.SUBMITIN_END, getClass() );
            return ret;
        }

        // get url from the property table
        String endPoint = propertyLookup.getProperty("vler.das.docsubmit.url");
        if(NullChecker.isNullOrEmpty(endPoint)) {
            errorMsg = "VLER DAS URL vler.das.docsubmit.url is not configured in the VA Adapter PROPERTIES table";
            ret = createErrorRegistryResponseType("XDSRegistryError", errorMsg, homeFacility);

            // CCR 177986 - parameterized logging
            logger.error(errorMsg + "{}");
						afac.debug( AuditingEvent.SUBMITIN_END, getClass() );
            return ret;
        }

        logger.debug("VLER DAS URL template {} = " + endPoint);

        // instantiate Das Http client
        DasDAO dasDAO;
        dasDAO = new DasDAOHttpImpl(endPoint);

        DasOperationSendImmunizationDataRequest req;
        DasOperationSendImmunizationDataResponse res;

        // call VLER DAS Immunization push
        try {
            req = new DasOperationSendImmunizationDataRequest();
            req.setMessage(c32document);

            req.setFacility(facilityNumber);
            req.setICN(icn);

						afac.debug( AuditingEvent.SUBMITIN_STORE, getClass() );
            res = dasDAO.doOperationSendImmunizationData(req);

            ret = createRegistryResponseType(res.getDocId());

            auditDocumentSubmission(assertion, body, res);
        } catch(DasException e) {
            ret = createErrorRegistryResponseType(e.getErrorCode(), e.getCodeContext(), homeFacility);

            // CCR 177986
            logger.error("Severe: DAS Exception {}", e.getCodeContext());
        }

        // copy request Id from request
        ret.setRequestId(requestId);

        // CCR 177986 - parameterized logging
        logger.debug("provideAndRegisterDocumentSetb() exited");
				afac.debug( AuditingEvent.SUBMITIN_END, getClass() );
        return ret;
    }

    /*
     * Builds RegistryResponseType with Bson Doc Id as a slot content
     *
     * @param docId Bson Doc Id generated by VLER DAS
     *
     * @return response RegistryResponseType containing docId
     */
    private RegistryResponseType createRegistryResponseType(String docId) {

        oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory of = new oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory();

        RegistryResponseType ret = of.createRegistryResponseType();

        SlotListType slotList = new SlotListType();
        SlotType1 slot = new SlotType1();
        slot.setName("DocumentId");

        ValueListType valueListType = new ValueListType();
        valueListType.getValue().add(docId);
        slot.setValueList(valueListType);
        slotList.getSlot().add(slot);
        ret.setResponseSlotList(slotList);

        ret.setStatus(XDS_RETRIEVE_RESPONSE_STATUS_SUCCESS);

        // CCR 177986- only if logger is enabled
        logger.debug("RegistryResponseType ret {}", ret);

        return ret;
    }

    private RegistryResponseType createErrorRegistryResponseType(String errorCode, String codeContext, Facility homeFacility) {
        oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory of = new oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory();

        RegistryResponseType ret = of.createRegistryResponseType();

        RegistryErrorList registryErrorList = createRegistryErrorList();

        RegistryError registryError = createRegistryError(errorCode, codeContext, homeFacility);

        registryErrorList.getRegistryError().add(registryError);

        ret.setRegistryErrorList(registryErrorList);

        ret.setStatus(XDS_RETRIEVE_RESPONSE_STATUS_FAILURE);

        // CCR 177986- only if logger is enabled
        logger.debug("RegistryResponseType ret {}", ret);

        return ret;
    }

    private RegistryErrorList createRegistryErrorList() {
        oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory retObjFactory = new oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory();
        RegistryErrorList ret = retObjFactory.createRegistryErrorList();
        ret.setHighestSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        return ret;
    }

    private RegistryError createRegistryError(String errorCode, String codeContext, Facility homeFacility) {
        oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory retObjFactory = new oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory();
        RegistryError ret = retObjFactory.createRegistryError();
        ret.setSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        ret.setErrorCode(errorCode);
        ret.setCodeContext(codeContext);

        if(NullChecker.isNullOrEmpty(homeFacility)) {
            ret.setLocation("");
        } else {
            ret.setLocation(homeFacility.getFullHomeCommunityId());
        }

        return ret;
    }

    /*
     * Look up Facility data in the FACILITIES table
     */
    private Facility getHomeFacility(String homeCommunityId)
    {
        Facility facility = null;

        facility = facilityManager.getFacilityByFullHomeCommunityId(homeCommunityId);

        if(NullChecker.isNotNullOrEmpty(facility)) {
            return facility;
        }

        facility = facilityManager.getFacilityByHomeCommunityId(homeCommunityId);

        // CCR 177986- only if logger is enabled
        logger.debug("facility name {}", facility.getFacilityName());
        logger.debug("facility number {}", facility.getFacilityNumber());
        logger.debug("Home Community Id {}", facility.getFullHomeCommunityId());

        return facility;
    }

    /*
     * retrieve C32 document <ProvideAndRegisterDocumentSetRequest> <Document
     * id="Walgreens">UjBsR09EbGhjZ0dTQUxNQUFBUUNBRU1tQ1p0dU1GUXhEUzhi</
     * Document> </ProvideAndRegisterDocumentSetRequest>
     */
    private byte[] getC32Document(ProvideAndRegisterDocumentSetRequestType body)
    {
        if(NullChecker.isNullOrEmpty(body.getDocument())) {
            //CCR 177986
            logger.error("Severe {}", "Document section is empty");
            return null;
        }

        byte[] c32bytes = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            body.getDocument().get(0).getValue().writeTo(baos);
            c32bytes = baos.toByteArray();
        } catch(IOException e) {
            //CCR 177986
            logger.error("Severe {}", "Error getting Document from ProvideAndRegisterDocumentSet");
            return null;
        }

        if(NullChecker.isNullOrEmpty(c32bytes)) {
            //CCR 177986
            logger.error("Severe {}", "Document content is empty");
            return null;
        }

        return c32bytes;
    }

    /*
     * retrieve ICN from RegistryObjectList:
     */
    private String getICN(ProvideAndRegisterDocumentSetRequestType body)
    {
        String uniquePatientId = getUniquePatientId(body);

        if(NullChecker.isNotNullOrEmpty(uniquePatientId)) {
            logger.debug("uniquePatientId {} : ", uniquePatientId);
            return uniquePatientId.split("\\^")[0];
        }

        return null;
    }

    private String getUniquePatientId(ProvideAndRegisterDocumentSetRequestType body)
    {
        RegistryPackageType registryPackage;

        List<ExternalIdentifierType> registryPackageExternalIdentifierList;

        RegistryObjectListType registryObjectList = body.getSubmitObjectsRequest().getRegistryObjectList();

        List<JAXBElement<? extends IdentifiableType>> identifiableList = registryObjectList.getIdentifiable();

        for(JAXBElement<? extends IdentifiableType> identifiable : identifiableList) {

            // check RegistryPackage of the DS request for
            // XDSSubmissionSet.patientId
            if(identifiable.getValue() instanceof RegistryPackageType) {
                registryPackage = (RegistryPackageType) identifiable.getValue();

                // get ExternalIdentifiers
                registryPackageExternalIdentifierList = registryPackage.getExternalIdentifier();
                for(ExternalIdentifierType registryPackageExternalIdentifier : registryPackageExternalIdentifierList) {
                    if(registryPackageExternalIdentifier.getName().getLocalizedString().get(0).getValue().equalsIgnoreCase("XDSSubmissionSet.patientId")) {
                        return registryPackageExternalIdentifier.getValue();
                    }
                }

            }

            // check ExtrinsicObject of the DS request
            /*
             * if (identifiable.getValue() instanceof ExtrinsicObjectType) {
             * extrinsicObject = (ExtrinsicObjectType)identifiable.getValue();
             *
             * extrinsicObjectExternalIdentifierList =
             * extrinsicObject.getExternalIdentifier(); for
             * (ExternalIdentifierType extrinsicObjectExternalIdentifier:
             * extrinsicObjectExternalIdentifierList) { if
             * (extrinsicObjectExternalIdentifier.getName().getLocalizedString()
             * .get(0).getValue()
             * .equalsIgnoreCase("XDSDocumentEntry.patientId")) { return
             * extrinsicObjectExternalIdentifier.getValue(); } } }
             */
        }
        return null;
    }

    private String getHomeCommunityId(AssertionType assertion)
    {
        if(NullChecker.isNullOrEmpty(assertion)) {
            logger.error("Severe {}", "Assertion section is empty");

            return null;
        }

        if(NullChecker.isNullOrEmpty(assertion.getHomeCommunity())) {
            logger.error("Severe {}", "HomeCommunity section is empty");

            return null;
        }

        String homeCommunityId = assertion.getHomeCommunity().getHomeCommunityId().trim();

        //CCR 177986
        logger.debug("homeCommunityId {} :", homeCommunityId);

        if(homeCommunityId.startsWith("urn:oid:")) {
            return homeCommunityId;
        } else {
            return "urn:oid:" + homeCommunityId;
        }
    }

    private String getRequestId(ProvideAndRegisterDocumentSetRequestType body)
    {
        if(NullChecker.isNullOrEmpty(body.getSubmitObjectsRequest())) {
            return "";
        }

        if(NullChecker.isNullOrEmpty(body.getSubmitObjectsRequest().getId())) {
            return "";
        }

        //CCR 177986
        logger.debug("request id {} ", body.getSubmitObjectsRequest().getId() );

        return body.getSubmitObjectsRequest().getId();
    }

    private void auditDocumentSubmission(AssertionType assertion, ProvideAndRegisterDocumentSetRequestType body, DasOperationSendImmunizationDataResponse response)
    {

        // create record in the DOCUMENT table

        Document document = new Document();

        byte[] c32bytes = getC32Document(body);
        document.setDocumentUniqueId(response.getDocId());
        document.setRawData(c32bytes);
        document.setSize(c32bytes.length);
        document.setAvailabilityStatus("urn:oasis:names:tc:ebxmlregrep:StatusType:Approved");
        document.setLastAccessedTime(new Date());
        document.setCreationTime(new Date());
        document.setClassCode("11369-6");
        document.setClassCodeDisplayName("History of immunizations");
        document.setClassCodeScheme("2.16.840.1.113883.6.1");
        document.setMimeType("text/xml");
        document.setPatientId(getICN(body));
        document.setFormatCodeDisplayName("History of immunizations");
        document.setSourcePatientId(getUniquePatientId(body));
        document.setPatientSSN(assertion.getSSN());

        if(NullChecker.isNotNullOrEmpty(assertion.getUserInfo())) {

            if(NullChecker.isNotNullOrEmpty(assertion.getUserInfo().getOrg())) {
                // document.setPatientPreferredFacilityNumber(assertion.getUserInfo().getOrg().getHomeCommunityId());
                document.setPatientPreferredFacilityName(assertion.getUserInfo().getOrg().getName());
            }

            document.setPatientGivenName(getGivenName(body));
            document.setPatientLastName(getFamilyName(body));

        }

        //CCR 177986
        logger.debug("Document details {}", document.toString());

        documentRepository.storeDocument(document);

        // create record in the AUDIT table
        Audit audit = new Audit();

        audit.setAction("DocumentSubmissionIn");
        audit.setAuditTime(new Date());
        audit.setDocumentId(document.getDocumentUniqueId());
        audit.setRemoteDocumentId(document.getDocumentUniqueId());
        // audit.setRemoteDocumentRepositoryId(d.getRepositoryUniqueId());
        audit.setRemoteOrganizationId(getHomeCommunityId(assertion));

        if(NullChecker.isNotNullOrEmpty(assertion.getUserInfo())) {
            audit.setUserId(assertion.getUserInfo().getUserName());

            if(NullChecker.isNotNullOrEmpty(assertion.getUserInfo().getRoleCoded())) {
                audit.setUserRole(assertion.getUserInfo().getRoleCoded().getCode());
            }

            if(NullChecker.isNotNullOrEmpty(assertion.getUserInfo().getOrg())) {
                audit.setUserFacilityNumber(assertion.getUserInfo().getOrg().getHomeCommunityId());
                audit.setUserFacilityName(assertion.getUserInfo().getOrg().getName());
            }

            if(NullChecker.isNotNullOrEmpty(assertion.getUserInfo().getPersonName())) {
                PersonNameType userName = assertion.getUserInfo().getPersonName();
                if(!NullChecker.isNullOrEmpty(userName.getFullName())) {
                    audit.setUserName(userName.getFullName());
                } else {
                    audit.setUserName(userName.getGivenName() + " " + userName.getFamilyName());
                }
            }
        }

        if(NullChecker.isNotNullOrEmpty(assertion.getPurposeOfDisclosureCoded())) {
            audit.setPurposeForUse(assertion.getPurposeOfDisclosureCoded().getCode());
        }

        audit.setSystemId(AuditUtil.checkSystemId(assertion));
        
        audit.setOrganizationId(assertion.getHomeCommunity().getHomeCommunityId());
        audit.setPatientId(getICN(body));
        audit.setPatientSSN(assertion.getSSN());

        audit.setPatientGivenName(getGivenName(body));
        audit.setPatientLastName(getFamilyName(body));
        audit.setPatientFacilityNumber(getHomeFacility(getHomeCommunityId(assertion)).getFacilityNumber());
        audit.setPatientFacilityName(getHomeFacility(getHomeCommunityId(assertion)).getFacilityName());

        audit.setDetails("ICN=" + audit.getPatientId() + ", VLER DAS Document Id=" + response.getDocId());

        //CCR 177986
        logger.debug("Audit details {}", audit.toString());

        auditManager.storeAudit(audit);
    }

    private String getFamilyName(ProvideAndRegisterDocumentSetRequestType body)
    {

        return getPartName(body, 0);
    }

    private String getGivenName(ProvideAndRegisterDocumentSetRequestType body)
    {

        return getPartName(body, 1);
    }

    private String getPartName(ProvideAndRegisterDocumentSetRequestType body, int n)
    {

        List<String> sourcePatientInfoList = getSourcePatientInfoList(body);

        if(NullChecker.isNullOrEmpty(sourcePatientInfoList)) {
            return null;
        }

        String patientFullName = getPatientFullName(sourcePatientInfoList);

        if(NullChecker.isNullOrEmpty(patientFullName)) {
            return null;
        }

        String partName = null;

        try {
            partName = patientFullName.split("\\^")[n];
        } catch(Exception e) {
            //CCR 179231
            logger.error("Exception in gettign part name from the document", e);
        }

        return partName;
    }

    private String getPatientFullName(List<String> sourcePatientInfoList)
    {
        if(NullChecker.isNullOrEmpty(sourcePatientInfoList)) {
            return null;
        }

        String patientFullName = null;

        for(String sourcePatientInfo : sourcePatientInfoList) {
            if(NullChecker.isNullOrEmpty(sourcePatientInfo)) {
                continue;
            }

            if(sourcePatientInfo.startsWith("PID-5|")) {
                patientFullName = sourcePatientInfo.substring(6);
                break;
            }
        }

        return patientFullName;
    }

    private List<String> getSourcePatientInfoList(ProvideAndRegisterDocumentSetRequestType body)
    {
        ExtrinsicObjectType extrinsicObject;
        List<SlotType1> extrinsicObjectSlotList;

        RegistryObjectListType registryObjectList = body.getSubmitObjectsRequest().getRegistryObjectList();

        List<JAXBElement<? extends IdentifiableType>> identifiableList = registryObjectList.getIdentifiable();

        for(JAXBElement<? extends IdentifiableType> identifiable : identifiableList) {

            if(identifiable.getValue() instanceof ExtrinsicObjectType) {
                extrinsicObject = (ExtrinsicObjectType) identifiable.getValue();

                // get Slots
                extrinsicObjectSlotList = extrinsicObject.getSlot();
                for(SlotType1 extrinsicObjectSlot : extrinsicObjectSlotList) {
                    // search for slot.name = 'sourcePatientInfo'
                    if(extrinsicObjectSlot.getName().equalsIgnoreCase("sourcePatientInfo")) {
                        return extrinsicObjectSlot.getValueList().getValue();
                    }
                }
            }
        }

        return null;
    }
}
