package gov.va.med.nhin.adapter.sensitiveInfo;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;

@Entity
@NamedQueries({ 
	@NamedQuery(name = "SensitiveInfo.listUniqueLocations", query = "SELECT DISTINCT si.location FROM SensitiveInfo si"), 
	@NamedQuery(name = "SensitiveInfo.getCountForSensitiveSections", query = "SELECT COUNT(si.infoId) FROM SensitiveInfo si WHERE si.location=:location AND si.sensitiveValue IN :valueList"), 
	@NamedQuery(name = "SensitiveInfo.getSensitiveInfosBySection", query = "SELECT si FROM SensitiveInfo si where si.location like :section") })
@Cache(
	// Cache everything until the JVM decides memory is low
	type = CacheType.SOFT,
	
	// Use 64,000 as the initial cache size.
	size = 64000,
	
	// 1 minutes
	expiry = 360000,
	
	// if cache coordination is used, only send invalidation messages.
	coordinationType = CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS 
)
@Table(name = "SENSITIVE_INFO")
public class SensitiveInfo
{
	@Id
	@Basic(optional = false)
	@Column(name = "INFO_ID")
	private int infoId;
	@Basic(optional = false)
	@Column(name = "LOCATION")
	private String location;
	@Column(name = "SENS_VALUE")
	private String sensitiveValue;

	/**
	 * @return the infoId
	 */
	public int getInfoId()
	{
		return infoId;
	}

	/**
	 * @param infoId the infoId to set
	 */
	public void setInfoId(int infoId)
	{
		this.infoId = infoId;
	}

	/**
	 * @return the location
	 */
	public String getLocation()
	{
		return location;
	}

	/**
	 * @param location the location to set
	 */
	public void setLocation(String location)
	{
		this.location = location;
	}

	/**
	 * @return the sensitiveValue
	 */
	public String getSensitiveValue()
	{
		return sensitiveValue;
	}

	/**
	 * @param sensitiveValue the sensitiveValue to set
	 */
	public void setSensitiveValue(String sensitiveValue)
	{
		this.sensitiveValue = sensitiveValue;
	}
}
