package gov.va.med.nhin.adapter.logging;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.RespondingGatewayCrossGatewayRetrieveRequestType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType.DocumentRequest;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdHocRetrieveError
{
	private static final Logger logger = LoggerFactory.getLogger(AdHocRetrieveError.class.getName());

	/**
	 * For unknown errors in a request.
	 * 
	 * @param respondingGatewayType
	 * @param errorText
	 */
	public static void retrieveError(final RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayType, final String errorText)
	{
		if(respondingGatewayType != null)
		{
			respondingGatewayType.getRetrieveDocumentSetRequest().getDocumentRequest();
			@SuppressWarnings("unchecked")
			List<DocumentRequest> requests = (List<DocumentRequest>) (respondingGatewayType.getRetrieveDocumentSetRequest().getDocumentRequest() != null ? respondingGatewayType.getRetrieveDocumentSetRequest().getDocumentRequest() : Collections.emptyList());

			AssertionType assertionType = respondingGatewayType.getAssertion() != null ? respondingGatewayType.getAssertion() : null;
			retrieveError(requests, assertionType, errorText);
		}
	}

	public static void retrieveError(final RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayType, final ErrorMessage errorText)
	{
		retrieveError(respondingGatewayType, errorText.getMessage());
	}

	public static void retrieveError(final RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayType, final ErrorMessage errorText, final String additionalInfo)
	{
		retrieveError(respondingGatewayType, errorText.getMessage() + ": " + additionalInfo);
	}

	public static void retrieveError(final RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayType, final DocumentRequest request, final ErrorMessage errorText, final String additionalInfo)
	{
		retrieveError(request, respondingGatewayType.getAssertion(), errorText.getMessage() + ": " + additionalInfo);
	}

	public static void retrieveError(final RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayType, final DocumentRequest request, final ErrorMessage errorText)
	{
		retrieveError(request, respondingGatewayType.getAssertion(), errorText.getMessage());
	}

	public static String documentError(final DocumentRequest request)
	{
		StringBuilder sb = new StringBuilder();
		if(request != null)
		{
			sb.append("\tDocument ID: ").append(request.getDocumentUniqueId()).append("\n");
			sb.append("\tHCID: ").append(request.getHomeCommunityId()).append("\n");
			sb.append("\tRepository Unique ID: ").append(request.getRepositoryUniqueId()).append("\n");
		}
		else
		{
			sb.append("\tAll Document retrieve parameters are missing.\n");
		}
		if(sb.length() > 0)
		{
			return sb.toString();
		}

		return StringUtils.EMPTY;
	}

	public static String assertionError(final AssertionType assertionType)
	{
		StringBuilder sb = new StringBuilder();
		if(assertionType != null)
		{
			String hcid = assertionType.getHomeCommunity() != null && StringUtils.isNotBlank(assertionType.getHomeCommunity().getHomeCommunityId()) ? assertionType.getHomeCommunity().getHomeCommunityId() : "Missing";
			sb.append("\tAssertion HCID: ").append(hcid).append("\n");
		}
		else
		{
			sb.append("\tDocument Query Assertion is missing.\n");
		}
		if(sb.length() > 0)
		{
			return sb.toString();
		}

		return StringUtils.EMPTY;
	}

	public static void retrieveError(final List<DocumentRequest> requests, AssertionType assertionType, final String errorText)
	{
		StringBuilder sb = new StringBuilder();

		sb.append(LoggingUtils.ERROR_PREFIX).append(" ").append(errorText).append("\n");
		if(CollectionUtils.isNotEmpty(requests))
		{
			for(DocumentRequest request : requests)
			{
				sb.append(documentError(request));
			}
		}
		sb.append(assertionError(assertionType));

		//CCR 177986- logging updates
		logger.trace("error string {} ", sb);  
	}

	public static void retrieveError(final DocumentRequest request, AssertionType assertionType, final String errorText)
	{
		StringBuilder sb = new StringBuilder();

		sb.append(LoggingUtils.ERROR_PREFIX).append(" ").append(errorText).append("\n");
		sb.append(documentError(request));
		sb.append(assertionError(assertionType));

		logger.trace("error string {} ", sb);  //CCR 177986- logging updates
	}
}
