package gov.va.med.nhin.adapter.internalApp;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;

@Entity
@Cache(type = CacheType.SOFT, // Cache everything until the JVM decides memory
								// is low.
size = 64000, // Use 64,000 as the initial cache size.
expiry = 360000, // 1 minutes
coordinationType = CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS // if cache
																	// coordination
																	// is used,
																	// only send
																	// invalidation
																	// messages.
)
@Table(name = "INT_FAC_FILT")
public class InternalAppFilters
{
	@Id
	@Basic(optional = false)
	@Column(name = "FAC_FILT_ID")
	private int facSupId;
	@Basic(optional = false)
	@Column(name = "FACILTIY_ID")
	private int faciltiyId;
	@Column(name = "FILTER_ID")
	private int filterId;
	@Column(name = "ROOT_NAME")
	private String rootName;
	@Column(name = "OBJ_NAME")
	private String objName;
	@Column(name = "PARAM")
	private String parameter;

	/**
	 * @return the facSupId
	 */
	public int getFacSupId()
	{
		return facSupId;
	}

	/**
	 * @param facSupId the facSupId to set
	 */
	public void setFacSupId(int facSupId)
	{
		this.facSupId = facSupId;
	}

	/**
	 * @return the faciltiyId
	 */
	public int getFaciltiyId()
	{
		return faciltiyId;
	}

	/**
	 * @param faciltiyId the faciltiyId to set
	 */
	public void setFaciltiyId(int faciltiyId)
	{
		this.faciltiyId = faciltiyId;
	}

	/**
	 * @return the filterId
	 */
	public int getFilterId()
	{
		return filterId;
	}

	/**
	 * @param filterId the filterId to set
	 */
	public void setFilterId(int filterId)
	{
		this.filterId = filterId;
	}

	/**
	 * @return the rootName
	 */
	public String getRootName()
	{
		return rootName;
	}

	/**
	 * @param rootName the rootName to set
	 */
	public void setRootName(String rootName)
	{
		this.rootName = rootName;
	}

	/**
	 * @return the objName
	 */
	public String getObjName()
	{
		return objName;
	}

	/**
	 * @param objName the objName to set
	 */
	public void setObjName(String objName)
	{
		this.objName = objName;
	}

	/**
	 * @return the parameter
	 */
	public String getParameter()
	{
		return parameter;
	}

	/**
	 * @param parameter the parameter to set
	 */
	public void setParameter(String parameter)
	{
		this.parameter = parameter;
	}
}
