package gov.va.med.nhin.adapter.internalApp;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;

@Entity
@Cache(type = CacheType.SOFT, // Cache everything until the JVM decides memory
								// is low.
size = 64000, // Use 64,000 as the initial cache size.
expiry = 360000, // 1 minutes
coordinationType = CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS // if cache
																	// coordination
																	// is used,
																	// only send
																	// invalidation
																	// messages.
)
@Table(name = "INT_FACILITIES")
public class InternalAppFacility
{
	@Id
	@Basic(optional = false)
	@Column(name = "FACILITY_ID")
	private int facilityId;
	@Column(name = "FACILITY_NUMBER")
	private String facilityNum;
	@Column(name = "FACILITY_NAME")
	private String facilityName;

	/**
	 * @return the facilityId
	 */
	public int getFacilityId()
	{
		return facilityId;
	}

	/**
	 * @param facilityId the facilityId to set
	 */
	public void setFacilityId(int facilityId)
	{
		this.facilityId = facilityId;
	}

	/**
	 * @return the facilityNum
	 */
	public String getFacilityNum()
	{
		return facilityNum;
	}

	/**
	 * @param facilityNum the facilityNum to set
	 */
	public void setFacilityNum(String facilityNum)
	{
		this.facilityNum = facilityNum;
	}

	/**
	 * @return the facilityName
	 */
	public String getFacilityName()
	{
		return facilityName;
	}

	/**
	 * @param facilityName the facilityName to set
	 */
	public void setFacilityName(String facilityName)
	{
		this.facilityName = facilityName;
	}
}
