package gov.va.med.nhin.adapter.facilitymanager;

import java.util.List;

/**
 *
 * @author David Vazquez
 */
public interface FacilityManager
{
    public List<Facility> getAllFacilities();
    public List<Facility> getAllFacilities(String[] excludeFacilityNumbers);
    public Facility getFacilityByHomeCommunityId(String oid);
    public Facility getFacilityByFullHomeCommunityId(String fullHomeCommunityId);
    public Facility getFacilityByFacilityNumber(String facilityNumber);
    public List<Facility> getFacilitiesContainingAssigningAuthority(String assigningAuthorityOID);
    public void addAssigningAuthorityToFacility(String homeCommunityId, String assigningAuthorityOid, String assigningAuthorityName);
    
    public List<String> getQueryNamesToGenerateDocuments(String partnerHomeCommunityId);
    List<String> getQueryNamesToGenerateDocuments(String partnerHomeCommunityId, List<String> loinCodeListIn);
    
    public boolean isPartnerAllowed(final String homeCommunityId, final OperationOnOff operation);
}
