package gov.va.med.nhin.adapter.documentrepository;

import java.util.Date;
import java.util.List;

import javax.ejb.*;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author David Vazquez
 */
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "DocumentRepository", mappedName = "DocumentRepository")
public class DocumentRepositoryBean implements DocumentRepositoryLocal, DocumentRepositoryRemote
{
	private static final Logger logger = LoggerFactory.getLogger(DocumentRepositoryBean.class.getName());

	private EntityManager entityManager;

	@PersistenceContext
	public void setEntityManager(EntityManager entityManager)
	{
		this.entityManager = entityManager;
	}

	public void deleteDocument(Document document)
	{
		entityManager.remove(document);
	}

	public Document getDocumentByDocumentId(Long documentId)
	{
		Document ret = null;

		ret = entityManager.find(Document.class, documentId);
		logger.debug("Document by doc id {}", ret);

		return ret;
	}

	public Document getDocumentByDocumentUniqueId(String documentUniqueId)
	{
		Document ret = null;

		Query query = entityManager.createNamedQuery("Document.findByDocumentUniqueId");
		query.setParameter("documentUniqueId", documentUniqueId);

		ret = getSingleResult(query);
		logger.debug("document by unique id {}", ret);

		return ret;
	}

	public List<Document> getDocumentsByDocumentUniqueId(List<String> documentUniqueIds)
	{
		List<Document> ret = null;

		StringBuffer queryString = new StringBuffer();
		for(String documentUniqueId : documentUniqueIds)
		{
			if(queryString.length() > 0)
			{
				queryString.append(',');
			}
			queryString.append('\'').append(documentUniqueId).append('\'');
		}

		logger.debug("query String {} ", queryString);

		Query query = entityManager.createQuery("select d from Document d where d.documentUniqueId in (" + queryString + ")");
		ret = query.getResultList();

		return ret;
	}

        @TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public void storeDocument(Document document)
	{
		if(document.getDocumentId() == null)
		{
			entityManager.persist(document);
		}
		else
		{
			entityManager.merge(document);
		}

		logger.debug("document id {} ", document.getDocumentId());
		logger.debug("document size is {}", document.getSize());
	}

	public void deleteDocumentsNotAccessed(long documentRetentionTime)
	{
		Date documentRetentionTimeAgo = new Date(System.currentTimeMillis() - documentRetentionTime);
		Query query = entityManager.createQuery("delete from Document d where d.lastAccessedTime is null and d.creationTime < :documentRetentionTimeAgo");
		query.setParameter("documentRetentionTimeAgo", documentRetentionTimeAgo);
		int deletedDocuments = query.executeUpdate();

		logger.debug("Deleted {} " + deletedDocuments + " document(s) from repository because they were not accessed within {} " + documentRetentionTime + "ms of creation.");
	}

	private Document getSingleResult(Query query)
	{
		Document ret;

		try
		{
			ret = (Document) query.getSingleResult();
			logger.debug("document is {}", ret);
		}
		catch(NoResultException nre)
		{
			ret = null;
			logger.error("Result not found", nre);  //CCR 177986
		}

		return ret;
	}
}
