package gov.va.med.nhin.adapter.cache;

import java.io.Serializable;
import java.util.List;

import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.ejb.*;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.transaction.UserTransaction;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.SHA1Hash;

/**
 *
 * @author David Vazquez
 */
@Stateless(name = "CacheManager", mappedName = "CacheManager")
@TransactionManagement(value = TransactionManagementType.BEAN)
public class CacheManagerBean implements CacheManagerRemote, CacheManagerLocal
{
    private static final Logger logger = LoggerFactory.getLogger(CacheManagerBean.class.getName());

    private EntityManager entityManager;
    private SessionContext context;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager)
    {
        this.entityManager = entityManager;
    }

    @Resource
    public void setSessionContext(SessionContext context)
    {
        this.context = context;
    }

    public Serializable get(String key)
    {
        logger.debug("get() invoked");

        Serializable ret = null;
        String hash = SHA1Hash.getHash(key.getBytes());
        Query query = entityManager.createNamedQuery("Cache.findByHash");
        query.setParameter("hash", hash);
        List<Cache> results = query.getResultList();
        if (!NullChecker.isNullOrEmpty(results)) {
            ret = results.get(0).getData();
        }

        logger.debug("exiting get()");

        return ret;
    }

    public void put(String key, Serializable data)
    {
        UserTransaction ut = context.getUserTransaction();

        try {
            ut.begin();

            String hash = SHA1Hash.getHash(key.getBytes());
            Cache cache = new Cache();
            cache.setHash(hash);
            cache.setData(data);
            entityManager.persist(cache);

            ut.commit();
        }
        // CCR 179231
        catch (Exception e) {
            logger.error("Error occurred. Rolling back transaction.  See nested exception.", e);
            try {
                ut.rollback();
            }
            catch (Exception ex) {

                logger.error("Error: rolling back transaction.", ex);
            }
        }
    }
}
