package gov.va.vss.service.impl;

import java.io.InputStream;
import java.util.List;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.vss.AbstractTransactionalWebTest;
import gov.va.vss.model.donation.DonationLog;
import gov.va.vss.service.DonationLogService;

public class TestDonationLogServiceImpl extends AbstractTransactionalWebTest {

	@Autowired
	private DonationLogService service;

	@Test
	public void test() throws Exception {
		try (InputStream resourceAsStream = ClassLoader.class.getResourceAsStream("/test_donation_log_file.xml");) {
			List<DonationLog> list = service.importExternalDonations(resourceAsStream);
			for (DonationLog l : list) {
				System.out.println(l);
			}
		}
	}

}
