package gov.va.vss.persistence.impl.facility;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.junit.Test;

import gov.va.shared.model.lookup.sds.State;
import gov.va.shared.model.lookup.sds.VAFacility;
import gov.va.vss.model.facility.Facility;
import gov.va.vss.model.facility.FacilityType;
import gov.va.vss.model.facility.Location;
import gov.va.vss.model.facility.FacilityType.FacilityTypeValue;
import gov.va.vss.persistence.AbstractSortedDAOTest;
import gov.va.vss.persistence.dao.CustomizableSortedDAO;

public class TestLocationDAO extends AbstractSortedDAOTest<Location> {

	@Override
	protected CustomizableSortedDAO<Location> getSortedDAO() {
		return locationDAO;
	}

	@Override
	protected Location getInstanceToSave() throws Exception {
		VAFacility vaFacility = createNewVAFacility("999_UT");
		State state = stateDAO.findStateByPostalCode("CO");
		FacilityType type = facilityTypeDAO.findByLookup(FacilityTypeValue.TIMEKEEPING);
		Facility facility = Facility.createNew(vaFacility, state, type, null, ZoneId.of("US/Central"));
		Location l = new Location();
		l.setParent(facility);
		l.setName("unitTestLocation");
		return l;
	}

	@Test
	public void testCountVolunteersForLocations() throws Exception {
		VAFacility vaFacility = createNewVAFacility("999_UT");
		State state = stateDAO.findStateByPostalCode("CO");
		FacilityType type = facilityTypeDAO.findByLookup(FacilityTypeValue.TIMEKEEPING);
		Facility facility = Facility.createNew(vaFacility, state, type, null, ZoneId.of("US/Central"));
		facility = facilityDAO.saveOrUpdate(facility);
		
		Location l = new Location();
		l.setParent(facility);
		l.setName("unitTestLocation");
		saveAndFlush(l);
		
		l = new Location();
		l.setParent(facility);
		l.setName("unitTestLocation2");
		saveAndFlush(l);
		
		Set<Long> locationIds = locationDAO.findSome(2).stream().map(p -> p.getId()).collect(Collectors.toSet());
		Map<Long, Integer[]> counts = locationDAO.countVolunteersForLocations(locationIds);
		System.out.println(Arrays.toString(counts.values().iterator().next()));
	}

}
