package gov.va.vss.persistence.impl.facility;

import java.time.ZoneId;

import org.junit.Test;

import gov.va.shared.model.lookup.sds.State;
import gov.va.shared.model.lookup.sds.VAFacility;
import gov.va.vss.model.facility.Facility;
import gov.va.vss.model.facility.FacilityType;
import gov.va.vss.model.facility.FacilityType.FacilityTypeValue;
import gov.va.vss.persistence.AbstractSortedDAOTest;
import gov.va.vss.persistence.dao.CustomizableSortedDAO;

public class TestFacilityDAO extends AbstractSortedDAOTest<Facility> {

	@Override
	protected CustomizableSortedDAO<Facility> getSortedDAO() {
		return facilityDAO;
	}

	@Override
	protected Facility getInstanceToSave() throws Exception {
		VAFacility facility = createNewVAFacility("999_UT");
		State state = stateDAO.findStateByPostalCode("CO");
		FacilityType type = facilityTypeDAO.findByLookup(FacilityTypeValue.TIMEKEEPING);
		
		Facility newInstitution = Facility.createNew(facility, state, type, null, ZoneId.of("US/Central"));
		return newInstitution;
	}

	@Test
	public void testFindBySDSFacility() throws Exception {
		facilityDAO.findByVAFacility(getVAFacility().getId());
	}

}
