package gov.va.vss.persistence.impl.benefitingService;

import java.util.Arrays;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.vss.AbstractTransactionalWebDAOTest;
import gov.va.vss.model.benefitingService.BenefitingServiceRole;
import gov.va.vss.model.benefitingService.ScopeType;
import gov.va.vss.persistence.dao.CustomizableAppDAO;
import gov.va.vss.persistence.dao.benefitingService.BenefitingServiceRoleDAO;

public class TestBenefitingServiceRoleDAOImpl extends AbstractTransactionalWebDAOTest<BenefitingServiceRole> {

	@Autowired
	protected BenefitingServiceRoleDAO dao;

	@Override
	protected CustomizableAppDAO<BenefitingServiceRole> getDAO() {
		return dao;
	}

	@Override
	protected BenefitingServiceRole getInstanceToSave() {
		BenefitingServiceRole t = new BenefitingServiceRole();
		t.setBenefitingService(benefitingServiceDAO.findSome(1).get(0));
		t.setFacility(facilityDAO.findSome(1).get(0));
		t.setName("unitTestName");
		t.setScope(ScopeType.NATIONAL);
		return t;
	}

	@Test
	public void testFindByCriteria() {
		dao.findByCriteria(null, null, false, null);
		dao.findByCriteria(null, Arrays.asList(218L), false, null);
		dao.findByCriteria(null, Arrays.asList(218L), true, null);
	}

	@Test
	public void testQuickSearch() {
		dao.quickSearch("F", 218L, 10);
	}
	
	@Override
	protected boolean testDelete() {
		return true;
	}

}
