package gov.va.vss.persistence.impl.benefitingService;

import java.util.Arrays;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.vss.AbstractTransactionalWebDAOTest;
import gov.va.vss.model.benefitingService.BenefitingService;
import gov.va.vss.model.benefitingService.ScopeType;
import gov.va.vss.persistence.dao.CustomizableAppDAO;
import gov.va.vss.persistence.dao.benefitingService.BenefitingServiceDAO;

public class TestBenefitingServiceDAOImpl extends AbstractTransactionalWebDAOTest<BenefitingService> {

	@Autowired
	protected BenefitingServiceDAO dao;

	@Override
	protected CustomizableAppDAO<BenefitingService> getDAO() {
		return dao;
	}

	@Override
	protected BenefitingService getInstanceToSave() {
		BenefitingService t = new BenefitingService();
		t.setName("unitTestName");
		t.setScope(ScopeType.NATIONAL);
		return t;
	}
	
	@Test
	public void testBulkDeleteByCriteria() {
		dao.bulkDeleteByCriteria(1234L);
	}

	@Test
	public void testCountVolunteersForBenefitingServiceIds() {
		dao.countVolunteersForBenefitingServiceIds(Arrays.asList(1L, 2L, 3L));
	}

	@Override
	protected boolean testDelete() {
		return true;
	}

}
