package gov.va.vss.persistence;

import java.time.LocalDate;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.vss.AbstractTransactionalWebDAOTest;
import gov.va.vss.model.mealTicket.MealTicket;
import gov.va.vss.persistence.dao.CustomizableAppDAO;
import gov.va.vss.persistence.dao.MealTicketDAO;

public class TestMealTicketDAO extends AbstractTransactionalWebDAOTest<MealTicket> {

	@Autowired
	private MealTicketDAO mealTicketDAO;

	@Override
	protected CustomizableAppDAO<MealTicket> getDAO() {
		return mealTicketDAO;
	}

	@Test
	public void testFindByCriteria() {
		Long facilityId = new Long(218L);
		// test list meal ticket by facility and date
		mealTicketDAO.findByCriteria(facilityId, null, LocalDate.now());
		// Assert.assertFalse("Failed search for Meal Ticket - ",
		// mealTicketList.isEmpty());
	}

	@Override
	protected MealTicket getInstanceToSave() throws Exception {
		// TODO Auto-generated method stub
		return null;
	}

}
