package gov.va.vss.persistence;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.transaction.annotation.Transactional;

import gov.va.shared.model.AppUser;
import gov.va.shared.model.Role;
import gov.va.shared.model.Role.RoleType;
import gov.va.vss.AbstractTransactionalWebTest;

public class TestGrantableRoleDAO extends AbstractTransactionalWebTest {

	@Test
	@Transactional
	public void testFindAllGrantableRolesForUserId() {
		Long userId = null;
		List<AppUser> allUsers = appUserDAO.findAll();
		for (AppUser u : allUsers) {
			if (u.hasGlobalRole(RoleType.NATIONAL_ADMIN)) {
				userId = u.getId();
				break;
			}
		}
		
		Assert.assertNotNull(userId);
		// test get all grantable roles by user id
		List<Role> roleList = grantableRoleDAO.findAllGrantableRolesForUser(userId);
		Assert.assertFalse("Failed search for Grantable Roles - ", roleList.isEmpty());
	}

	@Test
	public void testFindAllGrantableRolesFoRoleId() {
		Long roleId = roleDAO.findSome(1).get(0).getId();
		// test get all grantable roles by user id
		grantableRoleDAO.findGrantableRolesForRole(roleId);
	}

}
