package gov.va.vss.persistence;

import java.math.BigDecimal;
import java.time.LocalDate;

import org.junit.Test;

import gov.va.vss.AbstractTransactionalWebDAOTest;
import gov.va.vss.model.expenditure.Expenditure;
import gov.va.vss.persistence.dao.CustomizableAppDAO;

public class TestExpenditureDAO extends AbstractTransactionalWebDAOTest<Expenditure> {

	@Override
	protected CustomizableAppDAO<Expenditure> getDAO() {
		return expenditureDAO;
	}

	@Override
	protected Expenditure getInstanceToSave() {
		Expenditure e = new Expenditure();
		e.setAmount(new BigDecimal("100.05"));
		e.setOriginator(user);
		e.setDescription("Some Item");
		e.setFacility(getFacility());
		e.setRequestDate(LocalDate.now());
		e.setDonGenPostFund(donGenPostFundDAO.findSome(1).get(0));
		return e;
	}

	@Override
	protected boolean testDelete() {
		return true;
	}

	@Test
	public void testFindByCriteria() {
		expenditureDAO.findByCriteria(getFacility().getId(), donGenPostFundDAO.findSome(1).get(0).getId(),
				LocalDate.of(2015, 1, 1), LocalDate.of(2016, 1, 1));
	}

}
