package gov.va.vss;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.PlatformTransactionManager;

import gov.va.shared.persistence.AppUserDAO;
import gov.va.shared.persistence.AppUserFacilityDAO;
import gov.va.shared.persistence.lookup.sds.GenderDAO;
import gov.va.shared.persistence.lookup.sds.StateDAO;
import gov.va.shared.persistence.lookup.sds.VAFacilityDAO;
import gov.va.shared.service.VAFacilityService;
import gov.va.shared.test.AbstractTransactionalAppTest;
import gov.va.vss.config.WebAppConfig;
import gov.va.vss.config.testOnly.AppTestConfig;
import gov.va.vss.persistence.dao.ApplicationParametersDAO;
import gov.va.vss.persistence.dao.AwardDAO;
import gov.va.vss.persistence.dao.DonationDetailDAO;
import gov.va.vss.persistence.dao.DonationReferenceDAO;
import gov.va.vss.persistence.dao.DonationSummaryDAO;
import gov.va.vss.persistence.dao.DonorDAO;
import gov.va.vss.persistence.dao.LetterTemplateDAO;
import gov.va.vss.persistence.dao.NationalOfficialDAO;
import gov.va.vss.persistence.dao.OccasionalWorkEntryDAO;
import gov.va.vss.persistence.dao.ParkingStickerDAO;
import gov.va.vss.persistence.dao.PrintRequestDAO;
import gov.va.vss.persistence.dao.UniformDAO;
import gov.va.vss.persistence.dao.WorkEntryDAO;
import gov.va.vss.persistence.dao.benefitingService.BenefitingServiceDAO;
import gov.va.vss.persistence.dao.benefitingService.BenefitingServiceRoleDAO;
import gov.va.vss.persistence.dao.benefitingService.BenefitingServiceRoleTemplateDAO;
import gov.va.vss.persistence.dao.benefitingService.BenefitingServiceRoleTypeDAO;
import gov.va.vss.persistence.dao.benefitingService.BenefitingServiceTemplateDAO;
import gov.va.vss.persistence.dao.facility.FacilityDAO;
import gov.va.vss.persistence.dao.facility.KioskDAO;
import gov.va.vss.persistence.dao.facility.LocationDAO;
import gov.va.vss.persistence.dao.leie.ExcludedEntityDAO;
import gov.va.vss.persistence.dao.lookup.AdministrativeUnitDAO;
import gov.va.vss.persistence.dao.lookup.DonationTypeDAO;
import gov.va.vss.persistence.dao.lookup.DonorTypeDAO;
import gov.va.vss.persistence.dao.lookup.FacilityTypeDAO;
import gov.va.vss.persistence.dao.lookup.LanguageDAO;
import gov.va.vss.persistence.dao.lookup.NACStatusDAO;
import gov.va.vss.persistence.dao.lookup.OrganizationTypeDAO;
import gov.va.vss.persistence.dao.lookup.StaffTitleDAO;
import gov.va.vss.persistence.dao.lookup.StdCreditCardTypeDAO;
import gov.va.vss.persistence.dao.lookup.StdVAVSTitleDAO;
import gov.va.vss.persistence.dao.lookup.TransportationMethodDAO;
import gov.va.vss.persistence.dao.lookup.VoluntaryServiceTypeDAO;
import gov.va.vss.persistence.dao.organization.OrganizationDAO;
import gov.va.vss.persistence.dao.requirement.RequirementDAO;
import gov.va.vss.persistence.dao.views.CombinedFacilityDAO;
import gov.va.vss.persistence.dao.views.FacilityAndVisnDAO;
import gov.va.vss.persistence.dao.volunteer.VoluntaryServiceStaffDAO;
import gov.va.vss.persistence.dao.volunteer.VolunteerAssignmentDAO;
import gov.va.vss.persistence.dao.volunteer.VolunteerDAO;
import gov.va.vss.persistence.dao.volunteer.VolunteerOrganizationDAO;
import gov.va.vss.test.util.TestObjectFactory;

@ContextConfiguration(classes = { WebAppConfig.class, AppTestConfig.class })
public abstract class AbstractTransactionalWebTest extends AbstractTransactionalAppTest {

	@Autowired
	protected AdministrativeUnitDAO administrativeUnitDAO;
	@Autowired
	protected ApplicationParametersDAO applicationParameterDAO;
	@Autowired
	protected AppUserFacilityDAO appUserFacilityDAO;
	@Autowired
	protected AppUserDAO appUserDAO;
	@Autowired
	protected AwardDAO awardDAO;
	@Autowired
	protected BenefitingServiceDAO benefitingServiceDAO;
	@Autowired
	protected BenefitingServiceRoleDAO benefitingServiceRoleDAO;
	@Autowired
	protected BenefitingServiceRoleTypeDAO benefitingServiceRoleTypeDAO;
	@Autowired
	protected BenefitingServiceTemplateDAO benefitingServiceTemplateDAO;
	@Autowired
	protected BenefitingServiceRoleTemplateDAO benefitingServiceRoleTemplateDAO;
	@Autowired
	protected CombinedFacilityDAO combinedInstitutionDAO;
	@Autowired
	protected DonationDetailDAO donationDetailDAO;
	@Autowired
	protected DonationSummaryDAO donationSummaryDAO;
	@Autowired
	protected DonationReferenceDAO donationReferenceDAO;
	@Autowired
	protected DonationTypeDAO donationTypeDAO;
	@Autowired
	protected DonorDAO donorDAO;
	@Autowired
	protected DonorTypeDAO donorTypeDAO;
	@Autowired
	protected ExcludedEntityDAO excludedEntityDAO;
	@Autowired
	protected FacilityAndVisnDAO facilityAndVISNDAO;
	@Autowired
	protected FacilityDAO facilityDAO;
	@Autowired
	protected FacilityTypeDAO facilityTypeDAO;
	@Autowired
	protected GenderDAO genderDAO;
	@Autowired
	protected KioskDAO kioskDAO;
	@Autowired
	protected LanguageDAO languageDAO;
	@Autowired
	protected LetterTemplateDAO letterTemplateDAO;
	@Autowired
	protected LocationDAO locationDAO;
	@Autowired
	protected NACStatusDAO nacStatusDAO;
	@Autowired
	protected NationalOfficialDAO nationalOfficialDAO;
	@Autowired
	protected OccasionalWorkEntryDAO occasionalWorkEntryDAO;
	@Autowired
	protected OrganizationDAO organizationDAO;
	@Autowired
	protected OrganizationTypeDAO organizationTypeDAO;
	@Autowired
	protected ParkingStickerDAO parkingStickerDAO;
	@Autowired
	protected PrintRequestDAO printRequestDAO;
	@Autowired
	protected RequirementDAO requirementDAO;
	@Autowired
	protected StateDAO stateDAO;
	@Autowired
	protected StdCreditCardTypeDAO stdCreditCardTypeDAO;
	@Autowired
	protected StdVAVSTitleDAO stdVAVSTitleDAO;
	@Autowired
	protected StaffTitleDAO staffTitleDAO;
	@Autowired
	protected TransportationMethodDAO transportationMethodDAO;
	@Autowired
	protected UniformDAO uniformDAO;
	@Autowired
	protected VAFacilityDAO vaFacilityDAO;
	@Autowired
	protected VoluntaryServiceStaffDAO voluntaryServiceStaffDAO;
	@Autowired
	protected VolunteerDAO volunteerDAO;
	@Autowired
	protected VolunteerAssignmentDAO volunteerAssignmentDAO;
	@Autowired
	protected VolunteerOrganizationDAO volunteerOrganizationDAO;
	@Autowired
	protected VoluntaryServiceTypeDAO voluntaryServiceTypeDAO;
	@Autowired
	protected WorkEntryDAO workEntryDAO;

	@Autowired
	protected VAFacilityService vaFacilityService;

	@Autowired
	protected DataSource dataSource;
	@Autowired
	protected TestObjectFactory testObjectFactory;

	@Autowired
	protected MessageSource messageSource;

	@PersistenceContext
	protected EntityManager em;

	@Autowired
	@Qualifier("transactionManager")
	protected PlatformTransactionManager tm;

}
