package gov.va.vss;

import javax.security.auth.login.LoginContext;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

import gov.va.shared.model.core.IdentifiedPersistent;
import gov.va.shared.persistence.lookup.sds.StateDAO;
import gov.va.shared.test.AbstractTransactionalDAOTest;
import gov.va.vss.config.WebAppConfig;
import gov.va.vss.config.testOnly.AppTestConfig;
import gov.va.vss.model.facility.Facility;
import gov.va.vss.persistence.dao.DonationLogDAO;
import gov.va.vss.persistence.dao.ExpenditureDAO;
import gov.va.vss.persistence.dao.LedgerAdjustmentDAO;
import gov.va.vss.persistence.dao.NationalOfficialDAO;
import gov.va.vss.persistence.dao.NotificationDAO;
import gov.va.vss.persistence.dao.OccasionalWorkEntryDAO;
import gov.va.vss.persistence.dao.WorkEntryDAO;
import gov.va.vss.persistence.dao.benefitingService.BenefitingServiceDAO;
import gov.va.vss.persistence.dao.benefitingService.BenefitingServiceRoleDAO;
import gov.va.vss.persistence.dao.benefitingService.BenefitingServiceRoleTemplateDAO;
import gov.va.vss.persistence.dao.benefitingService.BenefitingServiceRoleTypeDAO;
import gov.va.vss.persistence.dao.benefitingService.BenefitingServiceTemplateDAO;
import gov.va.vss.persistence.dao.donGenPostFund.DonGenPostFundDAO;
import gov.va.vss.persistence.dao.facility.FacilityDAO;
import gov.va.vss.persistence.dao.facility.LocationDAO;
import gov.va.vss.persistence.dao.lookup.FacilityTypeDAO;
import gov.va.vss.persistence.dao.lookup.LanguageDAO;
import gov.va.vss.persistence.dao.lookup.OrganizationTypeDAO;
import gov.va.vss.persistence.dao.lookup.StdVAVSTitleDAO;
import gov.va.vss.persistence.dao.organization.OrganizationDAO;
import gov.va.vss.persistence.dao.requirement.RequirementDAO;
import gov.va.vss.persistence.dao.views.FacilityAndVisnDAO;
import gov.va.vss.persistence.dao.volunteer.VoluntaryServiceStaffDAO;
import gov.va.vss.persistence.dao.volunteer.VolunteerAssignmentDAO;
import gov.va.vss.persistence.dao.volunteer.VolunteerDAO;
import gov.va.vss.test.util.TestObjectFactory;

@ContextConfiguration(classes = { WebAppConfig.class, AppTestConfig.class })
public abstract class AbstractTransactionalWebDAOTest<T extends IdentifiedPersistent>
		extends AbstractTransactionalDAOTest<T> {

	protected LoginContext vistaLoginContext = null;

	@Autowired
	protected BenefitingServiceDAO benefitingServiceDAO;
	@Autowired
	protected BenefitingServiceRoleDAO benefitingServiceRoleDAO;
	@Autowired
	protected BenefitingServiceTemplateDAO benefitingServiceTemplateDAO;
	@Autowired
	protected BenefitingServiceRoleTemplateDAO benefitingServiceRoleTemplateDAO;
	@Autowired
	protected BenefitingServiceRoleTypeDAO benefitingServiceRoleTypeDAO;
	@Autowired
	protected DonationLogDAO donationLogDAO;
	@Autowired
	protected DonGenPostFundDAO donGenPostFundDAO;
	@Autowired
	protected ExpenditureDAO expenditureDAO;
	@Autowired
	protected FacilityDAO facilityDAO;
	@Autowired
	protected FacilityTypeDAO facilityTypeDAO;
	@Autowired
	protected FacilityAndVisnDAO facilityAndVISNDAO;
	@Autowired
	protected LanguageDAO languageDAO;
	@Autowired
	protected LedgerAdjustmentDAO ledgerAdjustmentDAO;
	@Autowired
	protected LocationDAO locationDAO;
	@Autowired
	protected NationalOfficialDAO nationalOfficalDAO;
	@Autowired
	protected NotificationDAO notificationDAO;
	@Autowired
	protected OccasionalWorkEntryDAO occasionalWorkEntryDAO;
	@Autowired
	protected OrganizationDAO organizationDAO;
	@Autowired
	protected OrganizationTypeDAO organizationTypeDAO;
	@Autowired
	protected RequirementDAO requirementDAO;
	@Autowired
	protected StateDAO stateDAO;
	@Autowired
	protected StdVAVSTitleDAO stdVAVSTitleDAO;
	@Autowired
	protected VolunteerAssignmentDAO volunteerAssignmentDAO;
	@Autowired
	protected VoluntaryServiceStaffDAO voluntaryServiceStaffDAO;
	@Autowired
	protected VolunteerDAO volunteerDAO;
	@Autowired
	protected WorkEntryDAO workEntryDAO;

	@Autowired
	protected TestObjectFactory testObjectFactory;

	protected Facility getFacility() {
		return facilityDAO.findByStationNumber(TEST_STATION_NUMBER);
	}

}
