<%@ include file="../../shared/inc_header.jsp"%>

<tiles:importAttribute name="widgetId" scope="page" />
<tiles:importAttribute name="textInputAttributes" scope="page"
	ignore="true" />
<tiles:importAttribute name="initialValue" scope="page" ignore="true" />

<script type="text/javascript">
	(function() {
		registerWidget({
			getParameters : function() {
				return [ {
					displayName : "<c:out value="${widgetLabel}" />",
					paramName : "<c:out value="${widgetParamName}" />",
					paramValue : $("#${widgetId}").val()
				} ]
			},
			refresh : function(params, refreshCompleteCallback) {
				$("#${widgetId}").val("")
				refreshCompleteCallback()
			},		
			changeEventSelectors : [ "#${widgetId}" ],
			htmlValidationSelectors : [ "#${widgetId}" ],
			customValidator : function() {
				var date = getWidget("${widgetId}").getParameterValue()
				var today = new Date()
				var tokens = date.split("/");
				var month = tokens[0];
				var year = tokens[1];
				if (parseInt(month) > 12 || parseInt(month) < 1) {
					$("#${widgetId}").val("")
					return 'Please enter a month between 1 and 12'
				}
				
				var newYear = year.replace(/_/g, "")
				if (year == null || newYear == "" || parseInt(year) < 1900) {
					$("#${widgetId}").val("")
					return 'Please enter a valid year'
				}
						
				if (year > today.getFullYear() || (year == today.getFullYear() && month > today.getMonth()+1)) {
					$("#${widgetId}").val("")
					return 'Future date is not allowed'
				}	
				
				return null
			}
		})
	})()
	
	$(function() {
		$("#${widgetId}").mask(twoDigitMonthYearMask, {
			autoclear : false
		})
	})

</script>

<c:out value="${widgetLabel}" />
:
<input type="text" id="${widgetId}" ${textInputAttributes}
	value="${initialValue}" />