<%@ include file="../shared/inc_header.jsp"%>

<script type="text/javascript">
	function getReportPathExtension() {
		return ""
	}

	setWidgetsInitializedCallback(function() {
	
		
		var stationWidget = getWidget('stations')
		var serviceScopeWidget = getWidget('serviceScope')
		var serviceWidget = getWidget('services')
		var allServicesWidget = getWidget('allServices')
		var includeInactiveWidget = getWidget('includeInactive')
		var gamesOnlyWidget = getWidget('gamesOnly')
		var serviceFilterWidget = getWidget('serviceFilter')
		var filterStrWidget = getWidget('filterStr')

		stationWidget.toggle(true)

		serviceWidget
				.setRefreshParamProvider(function() {
					return {
						stationId : stationWidget.getParameterValue(),
						scope : serviceScopeWidget.getParameterValue(),
						gamesOnly : gamesOnlyWidget.getParameterValue() == 'Y' ? true
								: false,
						includeInactive : includeInactiveWidget
								.getParameterValue() == '1' ? true : false,
						startWith : serviceFilterWidget.getParameterValue() == 'Y' ? true
								: false,
						filterStr : filterStrWidget
								.getParameterValue()
								
					}
				})

		stationWidget
				.addValueUpdatedListener(function(evt, updatedReportParams) {
					var newVal = stationWidget.getParameterValue()
					var showStationDependentWidgets = $.isArray(newVal) && newVal.length > 0
			
						allServicesWidget.toggle(showStationDependentWidgets)
					var newVal = allServicesWidget.getParameterValue()
					var showFilterWidget = showStationDependentWidgets && newVal != '1'
					var hasFilterStr = filterStrWidget.getParameterValue() != ''
					
					
			serviceFilterWidget.toggle(showFilterWidget)
			filterStrWidget.toggle(showFilterWidget)
					
			var showService = (showStationDependentWidgets && hasFilterStr)
							
			serviceWidget.toggle(showService)
		
			if (showService)
				serviceWidget.refresh()		
				//servicesWidget
					//		.bypassReportParameters(!showStationDependentWidgets)

				})
				
				
		allServicesWidget.addValueUpdatedListener(function(evt,
				updatedReportParams) {
			var newVal = allServicesWidget.getParameterValue()
			var showFilterWidget = newVal != '1'
			var hasFilterStr = filterStrWidget.getParameterValue() != ''
			serviceFilterWidget.toggle(showFilterWidget)
			filterStrWidget.toggle(showFilterWidget)
			serviceWidget.toggle(showFilterWidget && hasFilterStr)

		})

				
		serviceScopeWidget
				.addValueUpdatedListener(function(evt, updatedReportParams) {
					serviceWidget.refresh()
				})

		includeInactiveWidget
				.addValueUpdatedListener(function(evt, updatedReportParams) {
					serviceWidget.refresh()
				})

		gamesOnlyWidget
				.addValueUpdatedListener(function(evt, updatedReportParams) {
					serviceWidget.refresh()
				})

		filterStrWidget.addValueUpdatedListener(function(evt,
				updatedReportParams) {
			var filterStr = filterStrWidget.getParameterValue() 
			if(filterStr.length < 2) {
				serviceWidget.toggle(false)
			}
			if (filterStr.length > 1) {
				serviceWidget.toggle(true)
				serviceWidget.refresh()
			}
		})

		serviceFilterWidget.addValueUpdatedListener(function(evt,
				updatedReportParams) {
			var hasFilterStr = filterStrWidget.getParameterValue() != ''
			if (hasFilterStr) {
				serviceWidget.toggle(true)
				serviceWidget.refresh()
			}
		})
		
	})

	setPreSubmitCallback(function(finalReportParams) {

		var beginDate = getWidget("beginDate").getParameterValue()
		var endDate = getWidget("endDate").getParameterValue()
		var tokens = beginDate.split("/");
		var beginMonth = tokens[0];
		var beginYear = tokens[1];
		tokens = endDate.split("/");
		var endMonth = tokens[0];
		var endYear = tokens[1];
		finalReportParams['BeginDate'] = beginMonth + '/1/' + beginYear;
		if (parseInt(endMonth) != 12)
			finalReportParams['EndDate'] = (parseInt(endMonth) + 1) + '/1/'
					+ endYear;
		else
			finalReportParams['EndDate'] = '1/1/' + (parseInt(endYear) + 1);

		var startMonths = beginYear * 12 + parseInt(beginMonth);
		var endMonths = endYear * 12 + parseInt(endMonth);
		var gap = endMonths - startMonths + 1;
		if (startMonths > endMonths)
			return 'Start Date cannot be greater than End Date.'
		if (gap > 12)
			return 'Begin and End date cannot span more than 12 months'

		delete finalReportParams['GamesRelated']
		finalReportParams['Games'] = getWidget("gamesOnly").getParameterValue() == "Y" ? '1'
				: '0'

		if (getWidget("includeInactive").getParameterValue() == '1') {
			finalReportParams['IsInactive'] = [ '0', '1' ]
		} else
			finalReportParams['IsInactive'] = '0'

		if (getWidget("allServices").getParameterValue() == '1') {
			finalReportParams['ServiceList'] = '-1'
		}
				
		return null
	})

	setPreValidationsCallback(function() {
		var allServices = getWidget('allServices').getParameterValue() == '1'
		var newVal = getWidget('stations').getParameterValue()
		var stationSelected = $.isArray(newVal) && newVal.length > 0
		
		if (!stationSelected) {
			return "Please select a facility."
		}
		var filterStr = getWidget('filterStr').getParameterValue()
		
		if (!allServices & filterStr.length < 2) {
			return "Please enter at least 2 characters of Filter String."
		}
	})
	
	
</script>

<div
	style="display: inline-block; vertical-align: top; text-align: right; min-width: 250px;">


	<%-- ====================================== Date params --%>

	<tiles:insertDefinition name="widgetMonthYearInput">
		<tiles:putAttribute name="widgetId" value="beginDate" cascade="true" />
		<tiles:putAttribute name="reportParamName" value="BeginDate" />
		<tiles:putAttribute name="displayLabel" value="Begin Date (MM/YYYY)" />
		<tiles:putAttribute name="submitAsReportParameters" value="true" />
		<tiles:putAttribute name="textInputAttributes"
			value='style="width:110px"' cascade="true" />
	</tiles:insertDefinition>

	<tiles:insertDefinition name="widgetMonthYearInput">
		<tiles:putAttribute name="widgetId" value="endDate" cascade="true" />
		<tiles:putAttribute name="reportParamName" value="EndDate" />
		<tiles:putAttribute name="displayLabel" value="End Date (MM/YYYY)" />
		<tiles:putAttribute name="submitAsReportParameters" value="true" />
		<tiles:putAttribute name="textInputAttributes"
			value='style="width:110px"' cascade="true" />
	</tiles:insertDefinition>

	<c:out value="Date range cannot exceed 12 months." />

</div>

<div
	style="display: inline-block; vertical-align: top; min-width: 500px; text-align: right">
	<div class="clearCenter" style="text-align: center">


		<tiles:insertDefinition name="widgetStationSelector">
			<tiles:putAttribute name="widgetId" value="stations" cascade="true" />
			<tiles:putAttribute name="reportParamName" value="StationList" />
			<tiles:putAttribute name="displayLabel" value="Select Facility:" />
			<tiles:putAttribute name="bypassAsReportParameters" value="false"
				cascade="true" />
			<tiles:putAttribute name="showAllFacilities" value="true"
				cascade="true" />
			<tiles:putAttribute name="mode" value="multiple" cascade="true" />
		</tiles:insertDefinition>


	<div
		style="display: inline-block; vertical-align: top; text-align: right; min-width: 250px;">
		<tiles:insertDefinition name="widgetCheckbox">
			<tiles:putAttribute name="widgetId" value="allServices"
				cascade="true" />
			<tiles:putAttribute name="reportParamName" value="AllServices" />
			<tiles:putAttribute name="displayLabel"
				value="All Services" />
			<tiles:putAttribute name="initChecked" value="checked" cascade="true" />
			<tiles:putAttribute name="submitAsReportParameters" value="false" />
			<tiles:putAttribute name="initialVisibility" value="hidden" />
		</tiles:insertDefinition>
		
	</div>
	
		<tiles:insertDefinition name="widgetSelectList">
			<tiles:putAttribute name="widgetId" value="serviceScope" cascade="true" />
			<tiles:putAttribute name="displayLabel" value="Service Scope" />
			<tiles:putAttribute name="submitAsReportParameters" value="true" />
			<tiles:putListAttribute name="items" cascade="true">
				<tiles:addAttribute value="All|A|Checked" />
				<tiles:addAttribute value="National|N" />
				<tiles:addAttribute value="Local|L" />
			</tiles:putListAttribute>
		</tiles:insertDefinition>
	
		<tiles:insertDefinition name="widgetCheckbox">
			<tiles:putAttribute name="widgetId" value="includeInactive"
				cascade="true" />
			<tiles:putAttribute name="reportParamName" value="IsInactive" />
			<tiles:putAttribute name="displayLabel"
				value="Include Inactive Benefiting Services" />
			<tiles:putAttribute name="submitAsReportParameters" value="true" />
		</tiles:insertDefinition>

		<tiles:insertDefinition name="widgetRadioButtons">
			<tiles:putAttribute name="widgetId" value="gamesOnly" cascade="true" />
			<tiles:putAttribute name="reportParamName" value="GamesRelated " />
			<tiles:putAttribute name="displayLabel" value="Games" />
			<tiles:putAttribute name="submitAsReportParameters" value="false" />
			<tiles:putListAttribute name="items" cascade="true">
				<tiles:addAttribute value="Yes|Y" />
				<tiles:addAttribute value="No|N|Checked" />
			</tiles:putListAttribute>
		</tiles:insertDefinition>
		
	<tiles:insertDefinition name="widgetRadioButtons">
		<tiles:putAttribute name="widgetId" value="serviceFilter"
			cascade="true" />
		<tiles:putAttribute name="reportParamName" value="serviceFilter " />
		<tiles:putAttribute name="displayLabel"
			value="Benefiting Service Name Filter Option" />
		<tiles:putAttribute name="submitAsReportParameters" value="false" />
		<tiles:putListAttribute name="items" cascade="true">
			<tiles:addAttribute value="Contains|N" />
			<tiles:addAttribute value="Starts With|Y|checked" />
		</tiles:putListAttribute>
		<tiles:putAttribute name="initialVisibility" value="hidden" />
	</tiles:insertDefinition>

	<tiles:insertDefinition name="widgetTextInput">
		<tiles:putAttribute name="widgetId" value="filterStr" cascade="true" />
		<tiles:putAttribute name="reportParamName" value="FilterString" />
		<tiles:putAttribute name="displayLabel" value="Filter String (Type at least 2 characters, then <Tab>)" />
		<tiles:putAttribute name="submitAsReportParameters" value="false" />
		<tiles:putAttribute name="inputType" value="string" cascade="true" />
		<tiles:putAttribute name="initialVisibility" value="hidden" />
	</tiles:insertDefinition>


	<%-- =========================Service params --%>

	<tiles:insertDefinition name="widgetServiceSelector">
		<tiles:putAttribute name="widgetId" value="services" cascade="true" />
		<tiles:putAttribute name="reportParamName" value="ServiceList" />
		<tiles:putAttribute name="displayLabel" value="Benefiting Service:" />
		<tiles:putAttribute name="mode" value="multiple" cascade="true" />
		<tiles:putAttribute name="bypassAsReportParameters" value="false" />
		<tiles:putAttribute name="initialVisibility" value="hidden" />
	</tiles:insertDefinition>

	</div>
</div>

