<%@ include file="../shared/inc_header.jsp"%>

<script type="text/javascript">
	function getReportPathExtension() {
		return getWidget("nationalOrLocal").getParameterValue() == 'N'
				&& getWidget("templateOnly").getParameterValue() == '1' ? "_Template"
				: ""
	}

	setWidgetsInitializedCallback(function() {
		var stationWidget = getWidget('station')
		var serviceTemplateWidget = getWidget('serviceTemplates')
		var serviceWidget = getWidget('services')
		var nationalOrLocalWidget = getWidget('nationalOrLocal')
		var templateOnlyWidget = getWidget('templateOnly')
		var includeInactiveWidget = getWidget('includeInactive')
		var gamesOnlyWidget = getWidget('gamesOnly')
		var serviceFilterWidget = getWidget('serviceFilter')
		var filterStrWidget = getWidget('filterStr')

		stationWidget.toggle(true)

		serviceWidget
				.setRefreshParamProvider(function() {
					return {
						stationId : nationalOrLocalWidget.getParameterValue() == 'L' ? stationWidget
								.getParameterValue()
								: '-1',
						gamesOnly : gamesOnlyWidget.getParameterValue() == 'Y' ? true
								: false,
						includeInactive : includeInactiveWidget
								.getParameterValue() == '1' ? true : false,
						startWith : serviceFilterWidget.getParameterValue() == 'Y' ? true
								: false,
						filterStr : nationalOrLocalWidget.getParameterValue() == 'N' ? filterStrWidget
								.getParameterValue()
								: ''
					}
				})

		serviceTemplateWidget
				.setRefreshParamProvider(function() {
					return {
						gamesOnly : gamesOnlyWidget.getParameterValue() == 'Y' ? true
								: false,
						includeInactive : includeInactiveWidget
								.getParameterValue() == '1' ? true : false
					}
				})

		nationalOrLocalWidget.addValueUpdatedListener(function(evt,
				updatedReportParams) {

			var templateOnly = templateOnlyWidget.getParameterValue()
			var templateOnlyDependentWidgets = templateOnly == '1'

			var newVal = nationalOrLocalWidget.getParameterValue()
			var showLocalDependentWidgets = newVal == 'L'
			var showTemplateOnlyDependentWidgets = !showLocalDependentWidgets
					&& templateOnlyDependentWidgets
			var hasFilterStr = filterStrWidget.getParameterValue() != ''
			var showService = (!showLocalDependentWidgets
					&& !templateOnlyDependentWidgets && hasFilterStr)
					|| (showLocalDependentWidgets && stationWidget
							.getParameterValue() != '-1')
			stationWidget.toggle(showLocalDependentWidgets)
			serviceWidget.toggle(showService)
			serviceFilterWidget.toggle(!showLocalDependentWidgets
					&& !templateOnlyDependentWidgets)
			filterStrWidget.toggle(!showLocalDependentWidgets
					&& !templateOnlyDependentWidgets)

			templateOnlyWidget.toggle(!showLocalDependentWidgets)
			serviceTemplateWidget.toggle(showTemplateOnlyDependentWidgets)
			if (showService)
				serviceWidget.refresh()

		})

		stationWidget
				.addValueUpdatedListener(function(evt, updatedReportParams) {
					var newVal = stationWidget.getParameterValue()
					var showStationDependentWidgets = newVal != ''
							&& stationWidget.getParameterValue() != '-1'
					serviceWidget.toggle(showStationDependentWidgets)
					serviceWidget.refresh()
				})

		includeInactiveWidget
				.addValueUpdatedListener(function(evt, updatedReportParams) {
					var refreshTemplate = nationalOrLocalWidget
							.getParameterValue() == 'N'
							&& templateOnlyWidget.getParameterValue() == '1'
					if (refreshTemplate)
						serviceTemplateWidget.refresh()
					else
						serviceWidget.refresh()
				})

		gamesOnlyWidget
				.addValueUpdatedListener(function(evt, updatedReportParams) {
					var refreshTemplate = nationalOrLocalWidget
							.getParameterValue() == 'N'
							&& templateOnlyWidget.getParameterValue() == '1'
					if (refreshTemplate)
						serviceTemplateWidget.refresh()
					else
						serviceWidget.refresh()
				})

		templateOnlyWidget.addValueUpdatedListener(function(evt,
				updatedReportParams) {
			var newVal = templateOnlyWidget.getParameterValue()
			var showServiceTemplateWidget = newVal == '1'
			var hasFilterStr = filterStrWidget.getParameterValue() != ''
			serviceFilterWidget.toggle(!showServiceTemplateWidget)
			filterStrWidget.toggle(!showServiceTemplateWidget)
			serviceTemplateWidget.toggle(showServiceTemplateWidget)
			serviceWidget.toggle(!showServiceTemplateWidget && hasFilterStr)
			serviceTemplateWidget.refresh()
		})

		filterStrWidget.addValueUpdatedListener(function(evt,
				updatedReportParams) {
			var filterStr = filterStrWidget.getParameterValue() 
			if(filterStr.length < 2) {
				serviceWidget.toggle(false)
			}
			if (filterStr.length > 1) {
				serviceWidget.toggle(true)
				serviceWidget.refresh()
			}
		})

		serviceFilterWidget.addValueUpdatedListener(function(evt,
				updatedReportParams) {
			var hasFilterStr = filterStrWidget.getParameterValue() != ''
			if (hasFilterStr) {
				serviceWidget.toggle(true)
				serviceWidget.refresh()
			}
		})
	})

	setPreSubmitCallback(function(finalReportParams) {

		if (getWidget("nationalOrLocal").getParameterValue() == "N"
				&& getWidget("templateOnly").getParameterValue() == "1") {
			delete finalReportParams['Scope']
			delete finalReportParams['Facility']
			delete finalReportParams['ServiceList']
		} else {
			delete finalReportParams['BeneServTempList']
		}
		delete finalReportParams['GamesRelated']
		finalReportParams['Games'] = getWidget("gamesOnly").getParameterValue() == "Y" ? '1'
				: '0'

		if (getWidget("includeInactive").getParameterValue() == '1') {
			finalReportParams['IsInactive'] = [ '0', '1' ]
		} else
			finalReportParams['IsInactive'] = '0'

		return null
	})

	setPreValidationsCallback(function() {
		var templateOnly = getWidget('templateOnly').getParameterValue() == '1'
		var isNational = getWidget('nationalOrLocal').getParameterValue() == 'N'
		if(!isNational  && getWidget('station').getParameterValue() == '-1') {
			return "Please select a facility."
		}
		var filterStr = getWidget('filterStr').getParameterValue()
		
		if (!templateOnly && isNational && filterStr.length < 2) {
			return "Please enter at least 2 characters of Filter String."
		}
	})
</script>

<div
	style="display: inline-block; vertical-align: top; text-align: center; min-width: 250px;">
	<tiles:insertDefinition name="widgetRadioButtons">
		<tiles:putAttribute name="widgetId" value="nationalOrLocal"
			cascade="true" />
		<tiles:putAttribute name="reportParamName" value="Scope" />
		<tiles:putAttribute name="displayLabel" value="Facility" />
		<tiles:putAttribute name="submitAsReportParameters" value="true" />
		<tiles:putListAttribute name="items" cascade="true">
			<tiles:addAttribute value="All Facilities|N" />
			<tiles:addAttribute value="Local|L|Checked" />
		</tiles:putListAttribute>
	</tiles:insertDefinition>

	<tiles:insertDefinition name="widgetStationSelector">
		<tiles:putAttribute name="widgetId" value="station" cascade="true" />
		<tiles:putAttribute name="reportParamName" value="Facility" />
		<tiles:putAttribute name="displayLabel" value="Select Facility:" />
		<tiles:putAttribute name="bypassAsReportParameters" value="false"
			cascade="true" />
		<tiles:putAttribute name="showAllFacilities" value="false"
			cascade="true" />
		<tiles:putAttribute name="mode" value="single" cascade="true" />
		<tiles:putAttribute name="initialVisibility" value="hidden" />
	</tiles:insertDefinition>

	<div
		style="display: inline-block; vertical-align: top; text-align: right; min-width: 250px;">
		<tiles:insertDefinition name="widgetCheckbox">
			<tiles:putAttribute name="widgetId" value="templateOnly"
				cascade="true" />
			<tiles:putAttribute name="reportParamName" value="TemplateOnly" />
			<tiles:putAttribute name="displayLabel"
				value="Service Templates Only" />
			<tiles:putAttribute name="initChecked" value="checked" cascade="true" />
			<tiles:putAttribute name="submitAsReportParameters" value="false" />
			<tiles:putAttribute name="initialVisibility" value="hidden" />
		</tiles:insertDefinition>

		<tiles:insertDefinition name="widgetCheckbox">
			<tiles:putAttribute name="widgetId" value="includeInactive"
				cascade="true" />
			<tiles:putAttribute name="reportParamName" value="IsInactive" />
			<tiles:putAttribute name="displayLabel"
				value="Include Inactive Benefiting Services" />
			<tiles:putAttribute name="submitAsReportParameters" value="true" />
		</tiles:insertDefinition>

		<tiles:insertDefinition name="widgetRadioButtons">
			<tiles:putAttribute name="widgetId" value="gamesOnly" cascade="true" />
			<tiles:putAttribute name="reportParamName" value="GamesRelated " />
			<tiles:putAttribute name="displayLabel" value="Games" />
			<tiles:putAttribute name="submitAsReportParameters" value="false" />
			<tiles:putListAttribute name="items" cascade="true">
				<tiles:addAttribute value="Yes|Y" />
				<tiles:addAttribute value="No|N|Checked" />
			</tiles:putListAttribute>
		</tiles:insertDefinition>
	</div>
	<tiles:insertDefinition name="widgetRadioButtons">
		<tiles:putAttribute name="widgetId" value="serviceFilter"
			cascade="true" />
		<tiles:putAttribute name="reportParamName" value="serviceFilter " />
		<tiles:putAttribute name="displayLabel"
			value="Benefiting Service Name Filter Option" />
		<tiles:putAttribute name="submitAsReportParameters" value="false" />
		<tiles:putListAttribute name="items" cascade="true">
			<tiles:addAttribute value="Contains|N" />
			<tiles:addAttribute value="Starts With|Y|checked" />
		</tiles:putListAttribute>
		<tiles:putAttribute name="initialVisibility" value="hidden" />
	</tiles:insertDefinition>

	<tiles:insertDefinition name="widgetTextInput">
		<tiles:putAttribute name="widgetId" value="filterStr" cascade="true" />
		<tiles:putAttribute name="reportParamName" value="FilterString" />
		<tiles:putAttribute name="displayLabel" value="Filter String (Type at least 2 characters, then <Tab>)" />
		<tiles:putAttribute name="submitAsReportParameters" value="false" />
		<tiles:putAttribute name="inputType" value="string" cascade="true" />
		<tiles:putAttribute name="initialVisibility" value="hidden" />
	</tiles:insertDefinition>


	<%-- =========================Service params --%>

	<tiles:insertDefinition name="widgetServiceSelector">
		<tiles:putAttribute name="widgetId" value="services" cascade="true" />
		<tiles:putAttribute name="reportParamName" value="ServiceList" />
		<tiles:putAttribute name="displayLabel" value="Benefiting Service:" />
		<tiles:putAttribute name="mode" value="multiple" cascade="true" />
		<tiles:putAttribute name="bypassAsReportParameters" value="false" />
		<tiles:putAttribute name="initialVisibility" value="hidden" />
	</tiles:insertDefinition>

	<tiles:insertDefinition name="widgetServiceTemplateSelector">
		<tiles:putAttribute name="widgetId" value="serviceTemplates"
			cascade="true" />
		<tiles:putAttribute name="reportParamName" value="BeneServTempList" />
		<tiles:putAttribute name="displayLabel" value="Benefiting Service:" />
		<tiles:putAttribute name="mode" value="multiple" cascade="true" />
		<tiles:putAttribute name="bypassAsReportParameters" value="false" />
		<tiles:putAttribute name="initialVisibility" value="hidden" />
	</tiles:insertDefinition>

</div>