<%@ include file="../shared/inc_header.jsp"%>

<script type="text/javascript">
	function getReportPathExtension() {
		return ""
	}

	setWidgetsInitializedCallback(function() {
		var stationWidget = getWidget('stationId')
		var organizationsWidget = getWidget('organizations')
		var dueDateWidget = getWidget('dueDate')

		stationWidget
				.addValueUpdatedListener(function(evt, updatedReportParams) {
					var newVal = stationWidget.getParameterValue()
					var showStationDependentWidgets = newVal && newVal != ''
					organizationsWidget.toggle(showStationDependentWidgets)
					organizationsWidget.refresh()
				})
				
		organizationsWidget.setRefreshParamProvider(function() {
			return {
				stationId : stationWidget.getParameterValue()
			}
		})
		
		dueDateWidget.setRefreshParamProvider(function() {
			return {
				dueDate : dueDateWidget.getParameterValue()
			}
		})
	})
	
	setPreValidationsCallback(function() {

		if(getWidget('stationId').getParameterValue() == '-1') {
			return 'Please select a facility'
		}	

		if(getWidget('organizations').getParameterValue() == '-1') {
			return 'Please select an organization'
		}	

		var dueDateWidget = getWidget('dueDate')
	
		if (dueDateWidget.getParameterValue() == null
				|| (!$.isArray(dueDateWidget.getParameterValue()) && $.trim(dueDateWidget.getParameterValue()) == '')) {

			return 'Please enter a value for Due Date'
		}	
		
	})
	
	
</script>




<div
	style="display: inline-block; vertical-align: top; text-align: center; min-width: 250px;">

	<tiles:insertDefinition name="widgetStationSelector">
		<tiles:putAttribute name="widgetId" value="stationId" cascade="true" />
		<tiles:putAttribute name="reportParamName" value="FacilityId" />
		<tiles:putAttribute name="displayLabel" value="Select Facility:" />
		<%-- <tiles:putAttribute name="bypassAsReportParameters" value="false"
			cascade="true" />--%>
					<tiles:putAttribute name="submitAsReportParameters" value="true" /> 
		<tiles:putAttribute name="showAllFacilities" value="false"
			cascade="true" />
		<tiles:putAttribute name="mode" value="single" cascade="true" />
	</tiles:insertDefinition>

	<%-- ====================================== Organization params =================================== --%>

	<tiles:insertDefinition name="widgetOrganizationSelector">
		<tiles:putAttribute name="widgetId" value="organizations"
			cascade="true" />
		<tiles:putAttribute name="reportParamName" value="OrganizationId" />
		<tiles:putAttribute name="displayLabel" value="Select Organization:" />
		<tiles:putAttribute name="includeLocal" value="true" cascade="true" /> 
		<tiles:putAttribute name="includeNational" value="true"	cascade="true" /> 
		<tiles:putAttribute name="includeBranches" value="false" cascade="true" />
		<tiles:putAttribute name="mode" value="single" cascade="true" />	
		<tiles:putAttribute name="bypassAsReportParameters" value="false" />
		<tiles:putAttribute name="initialVisibility" value="hidden" />
	</tiles:insertDefinition>

	<%-- ====================================== Date params =============================== --%>
	
	<tiles:insertDefinition name="widgetMonthYearInput">
		<tiles:putAttribute name="widgetId" value="dueDate" cascade="true" />
		<tiles:putAttribute name="reportParamName" value="DueDate" />
		<tiles:putAttribute name="displayLabel" value="Due Date: (MM/YYYY)" />
		<tiles:putAttribute name="submitAsReportParameters" value="true" />
		<tiles:putAttribute name="textInputAttributes"
			value='style="width:110px"' cascade="true" />
	</tiles:insertDefinition>

</div>