package gov.va.vss.web.volunteer;

import java.util.List;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fasterxml.jackson.annotation.JsonView;

import gov.va.vss.model.notification.Notification;
import gov.va.vss.model.notification.Notification.NotificationView;
import gov.va.vss.service.NotificationService.NotificationSearchResult;
import gov.va.vss.web.AbstractAppController;
import gov.va.vss.web.breadcrumbs.Breadcrumb;

@Controller
public class NotificationController extends AbstractAppController {

	@RequestMapping("/requirementNotifications.htm")
	@Breadcrumb("List Requirement Notifications")
	public String listRequirementNotifications(ModelMap model) {
		return "requirementNotifications";
	}

	@RequestMapping("/getRequirementNotifications")
	@JsonView(NotificationView.NotificationsForUser.class)
	public @ResponseBody List<Notification> getRequirementNotifications() {
		NotificationSearchResult searchResult = notificationService.getRequirementNotificationsForFacility(getFacilityContextId());
			return searchResult.getNotifications();
	}

}

