package gov.va.vss.web.donation;

import gov.va.vss.model.donation.Donor;
import gov.va.vss.model.organization.AbstractBasicOrganization;
import gov.va.vss.model.organization.ScopeType;
import gov.va.vss.web.AbstractVssCommand;

public class DonorCommand extends AbstractVssCommand {

	private Donor donor;
	private String desiredIndividualType;
	private String orgFacilityDisplay;
	private boolean processingEDonation;
	
	public DonorCommand() {
	}

	public DonorCommand(Donor donor) {
		this.donor = donor;
		this.desiredIndividualType = donor.getOrganization() != null ? "org"
				: donor.getVolunteer() != null ? "volunteer" : "individual";
	}
	
	public Donor getDonor() {
		return donor;
	}

	public void setOrganization(Donor donor) {
		this.donor = donor;
	}

	public String getDesiredIndividualType() {
		return desiredIndividualType;
	}

	public void setDesiredIndividualType(String desiredIndividualType) {
		this.desiredIndividualType = desiredIndividualType;
	}

	public void setDonor(Donor donor) {
		this.donor = donor;
	}

	public String getOrgFacilityDisplay() {
		if (this.orgFacilityDisplay == null) {
			AbstractBasicOrganization org = donor.getOrganization();
			
			// org is branch
			if (org != null && "Branch".equalsIgnoreCase(org.getScale()))  {
				this.orgFacilityDisplay = org.getRootOrganization().getScope() != ScopeType.NATIONAL? 
						org.getRootOrganization().getFacility().getDisplayName() : "NATIONAL";
			}
			else if(org != null) {// org is organization
				this.orgFacilityDisplay = org.getScope() != ScopeType.NATIONAL? org.getFacility().getDisplayName() : "NATIONAL";
			}
		}
		return this.orgFacilityDisplay;
	}
	
	public void setOrgFacilityDisplay(String orgFacilityDisplay) {
		this.orgFacilityDisplay = orgFacilityDisplay;
	}

	public String getMutillineAddressWithoutLineFeed() {
		String mutillineAddr = this.donor.getAddressMultilineDisplay();
		return mutillineAddr.replaceAll("\n", "--Newline--");
	}

	public boolean isProcessingEDonation() {
		return processingEDonation;
	}

	public void setProcessingEDonation(boolean processingEDonation) {
		this.processingEDonation = processingEDonation;
	}
}
