package gov.va.vss.web;

import java.io.Serializable;
import java.util.UUID;

import org.apache.commons.lang3.StringUtils;

public class AbstractVssCommand implements SingleConversationEnforcedCommand, Serializable {
	private static final long serialVersionUID = -7073472537136385965L;
	
	private UUID uniqueConversationUUID;

	public String resetConversationIdentifier() {
		uniqueConversationUUID = UUID.randomUUID();
		return getConversationIdentifier();
	}

	public boolean matchesConversationIdentifier(String uniqueIdentifier) {
		if (StringUtils.isBlank(uniqueIdentifier))
			return false;
		return UUID.fromString(uniqueIdentifier).equals(uniqueConversationUUID);
	}

	public String getConversationIdentifier() {
		return uniqueConversationUUID == null ? "" : uniqueConversationUUID.toString();
	}

}
