<%@ include file="shared/inc_header.jsp"%>

<script type="text/javascript">
	function submitForm(evt) {
		if ($('#kioskCode').val() == "" ||
				$('#kioskCode').val() == null) {
			displayAttentionDialog('Please select a kiosk before proceeding!');
			return
		}
		
		if (evt != null)
			doubleClickSafeguard($(evt.currentTarget))
		$('#kioskSettingsForm').submit()
	}
	
	$(function() {
		var kioskSelect = $('#kioskCode')[0];
		var myfilter = new filterlist(kioskSelect);
		
		$("#submitFormButton").click(submitForm)
		
		$('#selectedKiosk').bind('keyup', function(){
			var typedInVal = $(this).val();
			myfilter.set(typedInVal);
		})
		
		$("#kioskCode").unbind('dblclick')
		$("#kioskCode").dblclick(function () {
			// $("#list1").find('option:selected').each(function() {
				//put your code here whatever needed on double click
			// })
			submitForm()
		})
	})
</script>

<form:form id="kioskSettingsForm" name='kioskSettingsForm'
	method="POST" action="${home}/selectKiosk.htm">
	
	<table cellpadding="8" align="center">
		<tr valign="top">
			<td align="right" class="appFieldLabel"><label
				for='selectedKiosk'>Select Kiosk: <span
					class='requdIndicator'>*</span>
			</label></td>

			<td><input id='selectedKiosk' size="50"
				title="Enter some text here to filter the Kiosk List"><br />
				<i>(Enter some text to filter the list below)</i> <label
				for='hiddenCancelSubmit' style='display: none;'>(Enter some
					text to filter the list below)</label><input type='text'
				id='hiddenCancelSubmit' style='display: none;'></input></td>

		</tr>
		<tr align="center">
			<td><label for='kioskCode' style='display: none;'>Select
					a kiosk</label></td>
			<td align='left'><select name="kioskId" id="kioskCode"
				size='10'
				ondblclick='document.getElementById("kioskSettingsForm").submit();'>
					<c:forEach items="${kioskList}" var="kiosk">
						<c:choose>
							<c:when
								test="${not empty currentKioskId and fn:trim(currentKioskId) == fn:trim(facility.id)}">
								<option value="${kiosk.id}" selected="selected">
									<c:out value="${kiosk.facility.displayName}" /> - <c:out value="${kiosk.location}" />
								</option>
							</c:when>
							<c:otherwise>
								<option value="${kiosk.id}">
									<c:out value="${kiosk.facility.displayName}" /> - <c:out value="${kiosk.location}" />
								</option>
							</c:otherwise>
						</c:choose>
					</c:forEach>
			</select></td>
		</tr>
		<tr align="center">
			<td colspan="2"><a class="buttonAnchor" id="submitFormButton"
				tabIndex="0">Submit</a>  </td>
		</tr>
	</table>
</form:form>