package gov.va.shared.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.transaction.annotation.Transactional;

import gov.va.shared.persistence.AppUserDAO;
import gov.va.shared.persistence.AppUserFacilityDAO;
import gov.va.shared.persistence.AppUserFacilityRoleDAO;
import gov.va.shared.persistence.AppUserGlobalRoleDAO;
import gov.va.shared.persistence.GrantableRoleDAO;
import gov.va.shared.persistence.LdapPersonDAO;
import gov.va.shared.persistence.lookup.InactiveReasonDAO;
import gov.va.shared.persistence.lookup.RoleDAO;
import gov.va.shared.persistence.lookup.sds.VAFacilityDAO;

@Transactional
public abstract class AbstractAppServiceImpl {

	@Autowired
	private Environment env;

	@Autowired
	protected AppUserDAO appUserDAO;
	@Autowired
	protected AppUserFacilityDAO appUserFacilityDAO;
	@Autowired
	protected AppUserFacilityRoleDAO appUserFacilityRoleDAO;
	@Autowired
	protected AppUserGlobalRoleDAO appUserGlobalRoleDAO;
	@Autowired
	protected GrantableRoleDAO grantableRoleDAO;
	@Autowired
	protected InactiveReasonDAO inactiveReasonDAO;
	@Autowired
	protected LdapPersonDAO ldapPersonDAO;
	@Autowired
	protected RoleDAO roleDAO;
	@Autowired
	protected VAFacilityDAO vaFacilityDAO;

	protected boolean isUnitTest() {
		return env.acceptsProfiles("default");
	}

}
