package gov.va.shared.service;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Map;

import gov.va.shared.model.AppUser;
import gov.va.shared.service.validation.ServiceValidationException;

public interface AppUserService {

	int updateFieldsWithoutVersionCheck(long appUserID, boolean incrementVersion, Long lastVisitedDutyStationNumber,
			boolean setAccountLockDate, ZonedDateTime accountLockDate, Integer failedLoginCount);

	void logApplicationAccess(String activeDirectoryName, ZonedDateTime now);

	AppUser saveOrUpdate(AppUser appUser);

	/* For application-internal code only */
	AppUser saveOrUpdateWithoutAuthority(AppUser appUser);

	AppUser updateUser(long userId, Boolean enabled, Boolean locked, Boolean expired, ZoneId timezone,
			boolean updateRolesAndFacilities, Long defaultFacilityId, Collection<Long> globalRoles,
			Collection<Long> vaFacilityIds) throws ServiceValidationException;

	String updatePassword(long appUserId, String plaintextPassword);

	/**
	 * Removes the specified user from the system. Returns true if the user was
	 * successfully removed; false if the user could not be removed due to
	 * app-specific foreign key constraints - CPB
	 */
	void removeUser(long appUserId, Map<String, Object> userAdminCustomizationsModel);

	AppUser customizeUser(long userId, Collection<Long> roles, Collection<Long> vaFacilities)
			throws ServiceValidationException;

	AppUser createOrRetrieveUser(String activeDirectoryName, Map<String, Object> userAdminCustomizationsModel);

	AppUser updateUserFromLDAP(long appUserId, boolean checkAuthority);

	AppUser updatePreferences(long appUserId, Boolean soundsEnabled);

}
