package gov.va.shared.persistence.impl.lookup.sds;

import javax.persistence.NoResultException;

import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;

import gov.va.shared.model.lookup.LookupType;
import gov.va.shared.model.lookup.sds.Gender;
import gov.va.shared.persistence.impl.AbstractAppSortedDAOImpl;
import gov.va.shared.persistence.lookup.sds.GenderDAO;
import gov.va.shared.util.cache.CacheNames;

@Repository
public class GenderDAOImpl extends AbstractAppSortedDAOImpl<Gender> implements GenderDAO {

	@Cacheable(CacheNames.QUERIES_GENDER_DAO)
	@Override
	public Gender findByCode(String code) {
		try {
			return (Gender) query("from " + Gender.class.getName() + " where code = :code").setParameter("code", code)
					.getSingleResult();
		} catch (NoResultException e) {
			return null;
		}
	}

	@Cacheable(CacheNames.QUERIES_GENDER_DAO)
	@Override
	public Gender findByLookup(LookupType lookup) {
		return findRequiredByPrimaryKey(lookup.getId());
	}
}
