/*
 * jQuery Dropdown: A simple dropdown plugin that positions relative to the mouse click
 *
 * Based on: https://github.com/claviska/jquery-dropdown
 */
if (jQuery)
	(function($) {
		$.extend($.fn, {
			vssDropdown : function(method, data) {
				switch (method) {
				case 'show':
					show(null, $(this));
					return $(this);
				case 'hide':
					hide();
					return $(this);
				case 'attach':
					return $(this).attr('data-vss-dropdown', data);
				case 'detach':
					hide();
					return $(this).removeAttr('data-vss-dropdown');
				case 'disable':
					return $(this).addClass('vss-dropdown-disabled');
				case 'enable':
					hide();
					return $(this).removeClass('vss-dropdown-disabled');
				}
			}
		});

		function show(event, object) {

			var trigger = event ? $(this) : object, vssDropdown = $(trigger.attr('data-vss-dropdown')), isOpen = trigger
					.hasClass('vss-dropdown-open');

			// In some cases we don't want to show it
			if (event) {
				if ($(event.target).hasClass('vss-dropdown-ignore'))
					return;

				event.preventDefault();
				event.stopPropagation();
			} else {
				if (trigger !== object.target && $(object.target).hasClass('vss-dropdown-ignore'))
					return;
			}
			hide();

			if (isOpen || trigger.hasClass('vss-dropdown-disabled'))
				return;

			// Show it
			trigger.addClass('vss-dropdown-open');
			vssDropdown.data('vss-dropdown-trigger', trigger).show();

			// Position it
			position(event, object);

			// Trigger the show callback
			vssDropdown.trigger('show', {
				vssDropdown : vssDropdown,
				trigger : trigger
			});

		}

		function hide(event) {

			// In some cases we don't hide them
			var targetGroup = event ? $(event.target).parents().addBack() : null;

			// Are we clicking anywhere in a vss-dropdown?
			if (targetGroup && targetGroup.is('.vss-dropdown')) {
				// Is it a vss-dropdown menu?
				if (targetGroup.is('.vss-dropdown-menu')) {
					// Did we click on an option? If so close it.
					if (!targetGroup.is('A'))
						return;
				} else {
					// Nope, it's a panel. Leave it open.
					return;
				}
			}

			// Hide any vss-dropdown that may be showing
			$(document).find('.vss-dropdown:visible').each(function() {
				var vssDropdown = $(this);
				vssDropdown.hide().removeData('vss-dropdown-trigger').trigger('hide', {
					vssDropdown : vssDropdown
				});
			});

			// Remove all vss-dropdown-open classes
			$(document).find('.vss-dropdown-open').removeClass('vss-dropdown-open');
		}

		function hideAndResize(event) {
			// IE-11 patch for weird artifacts that it leaves behind
			// calls hide via listener
			$(window).resize()
		}
		
		function position(event, object) {
			var pageX = event ? event.pageX : object ? object.offset().left : -1
			var pageY = event ? event.pageY : object ? object.offset().top : -1
			var scrollLeft = $(document).scrollLeft()
			var scrollTop = $(document).scrollTop()

			var vssDropdown = $('.vss-dropdown:visible').eq(0), trigger = vssDropdown.data('vss-dropdown-trigger'), hOffset = trigger ? parseInt(
					trigger.attr('data-horizontal-offset') || 0, 10)
					: null, vOffset = trigger ? parseInt(trigger.attr('data-vertical-offset') || 0, 10) : null;

			if (vssDropdown.length === 0 || !trigger)
				return;

			vssDropdown.css({
				left : vssDropdown.hasClass('vss-dropdown-anchor-right') ? pageX - scrollLeft
						- (vssDropdown.outerWidth(true) - trigger.outerWidth(true))
						- parseInt(trigger.css('margin-right'), 10) + hOffset : pageX - scrollLeft
						+ parseInt(trigger.css('margin-left'), 10) + hOffset,
				top : pageY - scrollTop + trigger.outerHeight(true) - parseInt(trigger.css('margin-top'), 10) + vOffset
			})
		}

		function keydown(event) {
			if (event.which == 13) {
				event.preventDefault();
				event.stopPropagation();
				show(null, $(event.currentTarget))
				var firstLink = $(document).find('.vss-dropdown:visible').find("a").eq(0)
				firstLink.focus().addClass('active')
			}
		}

		function keydownLink(event) {
			var $a = $(event.currentTarget)
			var $ul = $a.closest('ul')
			var $allLinks = $ul.find('a')
			var linkIndex = $allLinks.index($a)
			
			switch (event.which) {
			case $.ui.keyCode.UP:
				event.preventDefault()
				event.stopPropagation()
				$ul.find('a.active').removeClass('active')
				linkIndex--
				if (linkIndex < 0) linkIndex = $allLinks.length - 1
				$allLinks.eq(linkIndex).focus().addClass('active')
				break
			case $.ui.keyCode.DOWN:
				event.preventDefault()
				event.stopPropagation()
				$ul.find('a.active').removeClass('active')
				linkIndex = (linkIndex + 1) % $allLinks.length
				$allLinks.eq(linkIndex).focus().addClass('active')
				break
			case $.ui.keyCode.ESCAPE:
				event.preventDefault()
				event.stopPropagation()
				hide(event)
				break
			case $.ui.keyCode.TAB:
				hide(event)
				break;
			}
		}

		function mouseoverLink(event) {
			$(event.currentTarget).closest('.vss-dropdown-menu').find('a.active').removeClass('active')
		}
		
		$(document).on('click.vss-dropdown', '[data-vss-dropdown]', show);
		$(document).on('keydown.vss-dropdown', '[data-vss-dropdown]', keydown);
		$(document).on('click.vss-dropdown', hideAndResize);

		$(document).on('mouseover.vss-dropdown', '.vss-dropdown-menu a', mouseoverLink);
		$(document).on('keydown.vss-dropdown', '.vss-dropdown-menu a', keydownLink);

		document.addEventListener('scroll', hide, true);
		$(window).on('resize', hide);

	})(jQuery);