package gov.va.vss.service.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import gov.va.shared.service.validation.ServiceValidationException;
import gov.va.vss.model.facility.StaffTitle;
import gov.va.vss.model.voluntaryService.VoluntaryServiceStaff;
import gov.va.vss.service.StaffTitleService;

@Service
public class StaffTitleServiceImpl extends AbstractServiceImpl implements StaffTitleService {
	private static final Logger log = LoggerFactory.getLogger(StaffTitleServiceImpl.class);

	@Override
	public StaffTitle saveOrUpdate(StaffTitle staffTitle){
		return staffTitleDAO.saveOrUpdate(staffTitle);
	}
	
	@Override
	public void delete(long staffTitleId) throws ServiceValidationException {
		// An award code can be deleted if it has not been utilized.
		List<VoluntaryServiceStaff> linkedVolunteerServiceStaff = voluntaryServiceStaffDAO.findByStaffTitle(staffTitleId);
		if (!linkedVolunteerServiceStaff.isEmpty())
			throw new ServiceValidationException("staffTitle.error.staffTitleUsed");
		
		staffTitleDAO.delete(staffTitleId);
	}

}
