package gov.va.vss.service;

import java.time.LocalDate;
import java.util.List;

import gov.va.shared.service.validation.ServiceValidationException;
import gov.va.vss.model.notification.Notification;
import gov.va.vss.model.requirement.VolunteerRequirement;

public interface NotificationService {

	public static class NotificationSearchResult {
		private List<Notification> notifications;

		public NotificationSearchResult(List<Notification> notifications) {
			this.notifications = notifications;
		}

		public List<Notification> getNotifications() {
			return notifications;
		}

	}

	Notification saveOrUpdate(Notification o);

	void delete(long notificationId) throws ServiceValidationException;

	NotificationSearchResult getNotificationsForFacility(long facilityId);

	NotificationSearchResult getRequirementNotificationsForFacility(long facilityId);

	int purgeExpiredNotifications();

	List<Notification> getNotificationsForExpiringRequirements(long facilityId, List<VolunteerRequirement> volReqs);

	NotificationDispositionType getNotificationDisposition(LocalDate todayAtFacility, VolunteerRequirement vr);

}
