package gov.va.vss.service;

import java.util.List;

import gov.va.shared.service.validation.ServiceValidationException;
import gov.va.vss.model.benefitingService.BenefitingServiceRole;
import gov.va.vss.model.benefitingService.BenefitingServiceRoleType;

public interface BenefitingServiceRoleService {

	BenefitingServiceRole saveOrUpdate(BenefitingServiceRole benefitingServiceRole) throws ServiceValidationException;

	void saveOrUpdateAtLocations(List<Long> locationIds, Long benefitingServiceRoleId, Long benefitingServiceId,
			String name, String description, String contactName, String contactEmail, String contactPhone,
			BenefitingServiceRoleType roleType, boolean isEdit) throws ServiceValidationException;

	boolean canBeDeleted(long benefitingServiceRoleId);

	void merge(long fromBenefitingServiceRoleId, long toBenefitingServiceRoleId, boolean throwExceptionUponMergeFailure, boolean moveLocalSiblingsIfNecessary) throws ServiceValidationException;

	void reactivate(long benefitingServiceRoleId) throws ServiceValidationException;

	void deleteBenefitingServiceRole(long benefitingServiceRoleId);

	void inactivateBenefitingServiceRole(long benefitingServiceRoleId) throws ServiceValidationException;

	void deleteOrInactivateBenefitingServiceRole(long benefitingServiceRoleId) throws ServiceValidationException;

}
