package gov.va.vss.persistence.impl.lookup;

import java.util.List;

import org.springframework.stereotype.Repository;

import gov.va.vss.model.organization.NACStatus;
import gov.va.vss.persistence.dao.lookup.NACStatusDAO;
import gov.va.vss.persistence.impl.GenericHibernateDAOImpl;

@Repository
public class NACStatusDAOImpl extends GenericHibernateDAOImpl<NACStatus> implements NACStatusDAO {

	@Override
	public NACStatus findByMembershipStatus(String membershipStatus) {
		@SuppressWarnings("unchecked")
		List<NACStatus> results = query(
				"from " + NACStatus.class.getName() + " where membershipStatus = :membershipStatus")
						.setParameter("membershipStatus", membershipStatus).getResultList();
		return results.isEmpty() ? null : results.get(0);
	}

}
