package gov.va.vss.persistence.impl.lookup;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import gov.va.shared.util.LookupUtil;
import gov.va.vss.model.donation.DonorType;
import gov.va.vss.model.donation.DonorType.DonorTypeValue;
import gov.va.vss.persistence.dao.lookup.DonorTypeDAO;
import gov.va.vss.persistence.impl.GenericHibernateDAOImpl;

@Repository
public class DonorTypeDAOImpl extends GenericHibernateDAOImpl<DonorType> implements DonorTypeDAO {

	@Override
	public DonorType findByLookup(DonorTypeValue lookup) {
		@SuppressWarnings("unchecked")
		List<DonorType> results = query("from " + DonorType.class.getName() + " where id = :id")
				.setParameter("id", lookup.getId()).getResultList();
		return results.isEmpty() ? null : results.get(0);
	}

	@Override
	public Map<DonorTypeValue, DonorType> findByLookups(DonorTypeValue... lookups) {
		Map<DonorTypeValue, DonorType> results = new EnumMap<DonorTypeValue, DonorType>(DonorTypeValue.class);
		if (lookups == null)
			return results;

		for (DonorTypeValue v : lookups)
			results.put(v, null);

		@SuppressWarnings("unchecked")
		List<DonorType> r = query("from " + DonorType.class.getName() + " where id in (:ids)")
				.setParameter("ids", LookupUtil.translateTypesToIDs(lookups)).getResultList();
		for (DonorType dt : r)
			results.put(dt.getLookupType(), dt);

		return results;
	}

}
