package gov.va.vss.persistence.impl.lookup;

import java.util.List;

import org.springframework.stereotype.Repository;

import gov.va.vss.model.donation.DonationType;
import gov.va.vss.model.donation.DonationType.DonationTypeValue;
import gov.va.vss.persistence.dao.lookup.DonationTypeDAO;
import gov.va.vss.persistence.impl.GenericHibernateSortedDAOImpl;

@Repository
public class DonationTypeDAOImpl extends GenericHibernateSortedDAOImpl<DonationType>
		implements DonationTypeDAO {

	
	 public DonationType findByLookup(DonationTypeValue lookup) {
	 
		@SuppressWarnings("unchecked")
		List<DonationType> results = query("from " + DonationType.class.getName() + " where id = :id")
				.setParameter("id", lookup.getId()).getResultList();
		return results.isEmpty() ? null : results.get(0);
	}

}
