package gov.va.vss.persistence.impl.leie;

import java.util.List;

import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;

import gov.va.vss.model.leie.ExclusionType;
import gov.va.vss.persistence.dao.leie.ExclusionTypeDAO;
import gov.va.vss.persistence.impl.GenericHibernateDAOImpl;
import gov.va.vss.util.cache.CacheNames;

@Repository
public class ExclusionTypeDAOImpl extends GenericHibernateDAOImpl<ExclusionType> implements ExclusionTypeDAO {

	@Override
	@Cacheable(value = CacheNames.QUERIES_EXCLUSION_TYPE_DAO)
	public ExclusionType findBySSA(String ssa) {
		@SuppressWarnings("unchecked")
		List<ExclusionType> results = query("from " + ExclusionType.class.getName() + " where ssa = :ssa")
				.setParameter("ssa", ssa).getResultList();
		return results.isEmpty() ? null : results.get(0);
	}

}
