package gov.va.vss.persistence.impl;

import javax.persistence.NoResultException;

import org.springframework.stereotype.Repository;

import gov.va.vss.model.ApplicationParameter;
import gov.va.vss.persistence.dao.ApplicationParametersDAO;

@Repository
public class ApplicationParametersDAOImpl extends GenericHibernateDAOImpl<ApplicationParameter>
		implements ApplicationParametersDAO {

	@Override
	public ApplicationParameter findByName(String paramName) {
		try {
			return (ApplicationParameter) query(
					"from " + ApplicationParameter.class.getName() + " where parameterName = :parameterName")
							.setParameter("parameterName", paramName).getSingleResult();
		} catch (NoResultException e) {
			return null;
		}
	}
}
