package gov.va.vss.persistence.dao.facility;

import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;

import gov.va.vss.model.facility.Location;
import gov.va.vss.persistence.dao.CustomizableSortedDAO;

public interface LocationDAO extends CustomizableSortedDAO<Location> {

	SortedSet<Location> findByCriteria(Long parentFacilityId);

	/**
	 * Return integer array represents {active, total}
	 * @param locationIds
	 * @return
	 */
	Map<Long, Integer[]> countVolunteersForLocations(Collection<Long> locationIds);
	
}
