package gov.va.vss.persistence.dao.benefitingService;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import gov.va.vss.model.benefitingService.BenefitingService;
import gov.va.vss.persistence.dao.CustomizableSortedDAO;
import gov.va.vss.persistence.queryCustomization.QueryCustomization;

public interface BenefitingServiceDAO extends CustomizableSortedDAO<BenefitingService> {

	List<BenefitingService> findByCriteria(String name, String subdivision, String abbreviation,
			Collection<Long> facilityIds, Boolean templateIsNull, Boolean gamesRelated, Boolean activeStatus,
			Boolean includeInactive, Boolean startWith, String filterStr, String scope, QueryCustomization... customization);

	Map<Long, Integer[]> countVolunteersForBenefitingServiceIds(List<Long> benefitingServiceIds);

	int bulkUpdateByCriteria(Long benefitingServiceTemplateId, Long facilityOrLocationId, boolean updateName,
			String name, boolean updateAbbreviation, String abbreviation, boolean updateSubdivision, String subdivision,
			Boolean activeStatus, Boolean gamesRelated);

	int bulkDeleteByCriteria(Long benefitingServiceTemplateId);

	Map<Long, Integer> countOccasionalHoursForBenefitingServiceIds(List<Long> benefitingServiceIds);

	Map<Long, Integer> countOccasionalHoursForBenefitingServiceRoleIds(List<Long> benefitingServiceRoleIds);

}
