package gov.va.vss.persistence.dao.audit;

import java.time.ZonedDateTime;
import java.util.List;

import gov.va.shared.model.AppUser;
import gov.va.vss.model.AuditLogEntry;
import gov.va.vss.persistence.dao.CustomizableSortedDAO;
import gov.va.vss.persistence.queryCustomization.QueryCustomization;

public interface AuditLogEntryDAO extends CustomizableSortedDAO<AuditLogEntry> {

	List<AuditLogEntry> findByCriteria(AppUser appUser, String methodNameContains, ZonedDateTime earliestDate,
			ZonedDateTime latestDate, QueryCustomization... customization);

}
