package gov.va.vss.config;

import javax.management.MBeanServer;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.jmx.support.MBeanServerFactoryBean;
import org.springframework.scheduling.annotation.EnableAsync;

import gov.va.shared.config.AbstractConfig;
import gov.va.shared.config.LdapConfig;

@ComponentScan(basePackages = { "gov.va.shared",
		"gov.va.vss" }, excludeFilters = @ComponentScan.Filter(type = FilterType.REGEX, pattern = {
				"gov.va\\..*\\.config\\..*", "gov.va\\..*\\.web\\..*" }))
@EnableAsync(proxyTargetClass = true)
@EnableMBeanExport
@Import({ AOPConfig.class, CacheConfig.class, DataConfig.class, EmailConfig.class, LdapConfig.class,
		TemplateConfig.class })
public abstract class AbstractAppConfig extends AbstractConfig {

	@Bean
	public MBeanServer mbeanServer() {
		return new MBeanServerFactoryBean().getObject();
	}

}
