package gov.va.vss.persistence.impl.benefitingService;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.vss.AbstractTransactionalWebDAOTest;
import gov.va.vss.model.benefitingService.BenefitingServiceTemplate;
import gov.va.vss.persistence.dao.CustomizableAppDAO;
import gov.va.vss.persistence.dao.benefitingService.BenefitingServiceTemplateDAO;

public class TestBenefitingServiceTemplateDAOImpl extends AbstractTransactionalWebDAOTest<BenefitingServiceTemplate> {

	@Autowired
	protected BenefitingServiceTemplateDAO dao;

	@Override
	protected CustomizableAppDAO<BenefitingServiceTemplate> getDAO() {
		return dao;
	}

	@Override
	protected BenefitingServiceTemplate getInstanceToSave() {
		BenefitingServiceTemplate t = new BenefitingServiceTemplate();
		t.setName("unitTestName");
		return t;
	}

	@Test
	public void testGetUnusedBenefitingServiceAndRoleMap() {
		dao.getAssignableBenefitingServiceAndRoleTemplates(218L, null, false, false);
	}

	@Override
	protected boolean testDelete() {
		return true;
	}

}
