package gov.va.vss.persistence;

import java.util.List;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.shared.util.PersistenceUtil;
import gov.va.vss.AbstractTransactionalWebDAOTest;
import gov.va.vss.model.organization.AbstractBasicOrganization;
import gov.va.vss.model.volunteer.Volunteer;
import gov.va.vss.model.volunteer.VolunteerOrganization;
import gov.va.vss.persistence.dao.CustomizableAppDAO;
import gov.va.vss.persistence.dao.volunteer.VolunteerDAO;
import gov.va.vss.persistence.dao.volunteer.VolunteerOrganizationDAO;

public class TestVolunteerOrganizationDAO extends AbstractTransactionalWebDAOTest<VolunteerOrganization> {

	@Autowired
	private VolunteerOrganizationDAO dao;
	@Autowired
	private VolunteerDAO volunteerDAO;
	
	@Override
	protected CustomizableAppDAO<VolunteerOrganization> getDAO() {
		return dao;
	}

	@Override
	protected VolunteerOrganization getInstanceToSave() {
		VolunteerOrganization vo = new VolunteerOrganization();

		AbstractBasicOrganization o = organizationDAO.findSome(1).get(0);
		vo.setOrganization(o);

		Volunteer v = volunteerDAO.findSome(1).get(0);
		vo.setVolunteer(v);
		return vo;
	}

	@Override
	protected boolean testDelete() {
		return true;
	}

	@Test
	public void testInactivateForInactiveVolunteers() {
		dao.inactivateForInactiveVolunteers();
	}
	
	@Test
	public void testFindByCriteria() {
		dao.findByCriteria(null, null, true, facilityDAO.findSome(1).get(0).getId());
	}
	
	@Test
	public void testBulkUpdate() {
		List<Volunteer> some = volunteerDAO.findSome(2);
		AbstractBasicOrganization o = organizationDAO.findSome(1).get(0);
		dao.bulkUpdatePrimaryOrganizationsByCriteria(PersistenceUtil.translateObjectsToIds(some), true, o.getId());
		dao.bulkUpdatePrimaryOrganizationsByCriteria(PersistenceUtil.translateObjectsToIds(some), true, null);
	}
}
