package gov.va.vss.persistence;

import org.junit.Test;

import gov.va.vss.AbstractTransactionalWebDAOTest;
import gov.va.vss.model.facility.Facility;
import gov.va.vss.model.notification.Notification;
import gov.va.vss.model.notification.NotificationType;
import gov.va.vss.persistence.dao.CustomizableAppDAO;

public class TestNotificationDAO extends AbstractTransactionalWebDAOTest<Notification> {

	@Override
	protected CustomizableAppDAO<Notification> getDAO() {
		return notificationDAO;
	}

	@Override
	protected Notification getInstanceToSave() {
		return null;
	}

	@Test
	public void testPurge() {
		notificationDAO.purgeExpiredNotifications();
	}

	@Override
	protected boolean testDelete() {
		return false;
	}

	@Test
	public void testDeleteByCriteria() {
		Facility f = facilityDAO.findByStationNumber("442");
		notificationDAO.deleteByCriteria(f.getId(), NotificationType.DONATION);
	}

}
