package gov.va.vss.persistence;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import org.junit.Test;

import gov.va.vss.AbstractTransactionalWebDAOTest;
import gov.va.vss.model.donation.DonationLog;
import gov.va.vss.persistence.dao.CustomizableAppDAO;

public class TestDonationLogDAO extends AbstractTransactionalWebDAOTest<DonationLog> {

	@Override
	protected CustomizableAppDAO<DonationLog> getDAO() {
		return donationLogDAO;
	}

	@Override
	protected DonationLog getInstanceToSave() {
		DonationLog dl = new DonationLog();
		dl.setDonationAmount(new BigDecimal("10.00"));
		dl.setType("test");
		dl.setTrackingId("test1234");
		dl.setTransactionDate(LocalDateTime.now());
		dl.setFacility(TEST_STATION_NUMBER);
		dl.setName("test name");
		return dl;
	}

	@Override
	protected boolean testDelete() {
		return true;
	}

	@Test
	public void testCountByCriteria() {
		donationLogDAO.countByCriteria("442", true);
	}

}
