package gov.va.vss.persistence;

import org.junit.Test;

import gov.va.shared.model.core.AuditedPersistent;
import gov.va.vss.AbstractTransactionalWebDAOTest;
import gov.va.vss.persistence.dao.CustomizableAppDAO;
import gov.va.vss.persistence.dao.CustomizableSortedDAO;
import gov.va.vss.persistence.queryCustomization.QueryCustomization;

public abstract class AbstractSortedDAOTest<T extends Comparable<? super T> & AuditedPersistent>
		extends AbstractTransactionalWebDAOTest<T> {

	/**
	 * Subclasses must override this method to return the DAO under test.
	 * 
	 * @return
	 */
	protected abstract CustomizableSortedDAO<T> getSortedDAO();

	protected final CustomizableAppDAO<T> getDAO() {
		return getSortedDAO();
	}

	@Test
	public void testFindAllSorted() {
		getSortedDAO().findAllSorted();
	}

	@Test
	public void testFindAllSortedWithCustomization() {
		getSortedDAO().findAllSorted(new QueryCustomization(0, 1));
	}

}
