<%@ include file="../shared/inc_header.jsp"%>

<c:if test="${FORM_READ_ONLY}">
	<%@ include file="../shared/inc_modifyToView.jsp"%>
</c:if>

<script type="text/javascript">
	var isReadOnly = ${FORM_READ_ONLY}
	
	$(function() {
		var showDeleteAction = false
		<sec:authorize access="hasAuthority('${PERMISSION_VOL_SVC_STAFF_DELETE}')">
			showDeleteAction = !isReadOnly
		</sec:authorize>
		
		var theDataTable = $('#staffList').DataTable({
    		buttons : [{
					extend : 'excel',
					exportOptions: {
						columns : [0,1,2,3,4]
					}
				}, {
					extend : 'pdfHtml5',
					orientation : 'landscape',
					exportOptions: {
						columns : [0,1,2,3,4]
					}
				}, {
					extend : 'print',
					exportOptions: {
						columns : [0,1,2,3,4]
					}
				} ],
			"columnDefs" : [ {
					"targets" : 0,
					"data" : function(row, type, val, meta) {
						if (type === 'display') {
							return '<a href="javascript:showStaffDetailsPopup(' + row.id + ')">'
								+ escapeHTML(row.userInfo.fullDisplayName) +'</a>'
						}
						// used for 'filter', 'sort', 'type' and undefined
						return row.userInfo.fullDisplayName
					}
				}, {
					"targets" : 1,
					"data" : function(row) {
						return row.staffTitle ? row.staffTitle.name : ''
					}
				}, {
					"targets" : 2,
					"data" : function(row) {
						return row.vavsLeadership ? 'Yes' : 'No'
					}
				}, {
					"targets" : 3,
					"type" : "string",
					"data" : function(row, type, val, meta) {
						if (type === 'sort') {
							return row.vavsStartDate ? getAsYYYYMMDD(row.vavsStartDate) : ''
						}
						return row.vavsStartDate
					}
				}, {
					"targets" : 4,
					"type" : "string",
					"data" : function(row, type, val, meta) {
						if (type === 'filter') {
							return row.vavsEndDate ? 'Inactive' : 'Active'
						} 
						else if (type === 'sort') {
							return row.vavsEndDate ? getAsYYYYMMDD(row.vavsEndDate) : ''
						}
						return row.vavsEndDate
					}
				}, {
					"targets" : 5,
					"data" : function(row, type, val, meta) {
						var actions = '<div style="margin:0 auto; text-align:center">'
						if (showDeleteAction)
							actions += '<a href="javascript:deleteStaff('
									+ row.id + ')"><img src="'+ imgHomePath
									+ '/permanently_delete_18x18.png" border="0" hspace="5" align="center" alt="Delete Staff" /></a>'
						actions += '</div>'
						return actions
					}
				}
			],
	    	
			"dom": '<"top"fBi>rt<"bottom"pl><"clear">',
	    	"lengthMenu" : [ [ 10, 50, -1 ],
	    	 				[ 10, 50, "All" ] ],
			"order": [],
	    	"pageLength": 10,
	    	"pagingType": "full_numbers"
	    	
	    	})
	    
		$("#submitFormButton").click(submitForm)
		refreshStaffTable()
	})
	
	var staffList = new Object()
	
	function staffRefreshData(r) {
		var table = $('#staffList').DataTable()
		table.clear()
		table.rows.add(r)
		rebuildTableFilters('staffList')
		table.draw()
		
		$("#staffList_filter4").val('Active')
		$("#staffList_filter4").change()
	}
	
	function refreshStaffTable() {
		staffList = new Object()
		
		$.ajax({
			url : ajaxHomePath + '/voluntaryServiceStaff',
			dataType : 'json',
			data : {
				// serviceParametersId: '${command.serviceParameters.id}'
			},
			error : commonAjaxErrorHandler,
			success : function(response) {
				var rArray = new Array()
				
				for (var i = 0; i < response.length; i++) {
					staffList[response[i].id] = response[i]
					rArray[rArray.length] = response[i] 
				}
				$(".confirm").easyconfirm()	  

				staffRefreshData(rArray)
		    }
		})
	}
	
	function deleteStaff(staffId) {
		var fullObj = staffList[staffId]
	    confirmDialog('Are you sure you want to delete "' + fullObj.userInfo.lastName + ', ' + fullObj.userInfo.firstName + '"?',
                function() {
  					$.ajax({
					url : ajaxHomePath + '/deleteServiceStaff',
					dataType : 'json',
					data : {
						serviceStaffId: staffId
					},
					error : commonAjaxErrorHandler,
					success : function() {
						/* generated by inc_jqueryTable.jsp */
						refreshStaffTable()
				    }
				})
        })
	}  
	
	function submitForm(evt) {
		if (!validate())
			return
		if (evt != null)
			doubleClickSafeguard($(evt.currentTarget))
		$('#serviceParametersForm').submit()
	}

	function validate() {
		var errors = new Array()

		if ($('#serviceTitleInput').val() == '')
			errors.push("Service title is required.")
		
		if ($('#phoneId').val() == '')
			errors.push("Primary phone is required.")
		
		if ($('#phoneId').val() != '' && !validatePhone($('#phoneId').val()))
			errors.push("Primary phone number is invalid.")
		
		if ($('#mailStopId').val() == '')
			errors.push("Mail stop is required.")
		
		if ($('#secPhoneId').val() != '' && !validatePhone($('#secPhoneId').val()))
			errors.push("Alternate phone number is invalid.")
		
		if ($('#faxId').val() != '' && !validateFax($('#faxId').val()))
			errors.push("Fax number is invalid.")

		if ($('#operCostId').val() != '' && !validateNumeric($('#operCostId').val()))
			errors.push("Operating costs is invalid.")
		
		if ($('#staffCostId').val() != '' && !validateNumeric($('#staffCostId').val()))
			errors.push("Staff costs is invalid.")
		
		if (errors.length > 0)
			displayAttentionDialog("Please correct the following errors: <ul><li>"
					+ errors.join("</li><li>") + "</li></ul>");

		return errors.length == 0
	}
</script>

<style>
div.serviceParamContainer {
	min-width: 700px;
}
</style>

<form:form method="post" action="${home}/serviceParametersSubmit.htm"
	id="serviceParametersForm">
	<input id="serviceParameterId" type="hidden" value="serviceParameters." />
	<div class="clearCenter serviceParamContainer">
		<fieldset>
			<legend>Service And Contact Information</legend>
			<div class="leftHalf">
				<table>
					<tr>
						<td class='appFieldLabel' nowrap><label
							for='serviceTitleInput'>Service Title:<span
								class="invisibleRequiredFor508">*</span>
						</label></td>
						<td style="text-align: left"><span class='requdIndicator'>*</span></td>
						<td><app:input size="30" id="serviceTitleInput"
								path="serviceParameters.serviceTitle" /> <app:errors
								path="serviceParameters.serviceTitle" cssClass="msg-error" /></td>
					</tr>
					<tr>
						<td class='appFieldLabel' nowrap><label
							for='phoneId'>Primary Phone:<span
								class="invisibleRequiredFor508">*</span>
						</label></td>
						<td style="text-align: left"><span class='requdIndicator'>*</span></td>
						<td><app:input path="serviceParameters.primaryPhone"
								id="phoneId" cssClass="phoneextmask" size="20" /> <app:errors
								path="serviceParameters.primaryPhone" cssClass="msg-error" /></td>
					</tr>
					<tr>
						<td class='appFieldLabel'><label
							for='faxId'>Fax Number:</label></td>
						<td></td>
						<td><app:input path="serviceParameters.faxNumber" id="faxId"
								cssClass="faxmask" size="20" /> <app:errors
								path="serviceParameters.faxNumber" cssClass="msg-error" /></td>
					</tr>

				</table>
			</div>

			<div class="rightHalf">
				<table>
					<tr>
						<td class='appFieldLabel' nowrap><label
							for='serviceTypeSelect'>Service Type:<span
								class="invisibleRequiredFor508">*</span>
						</label></td>
						<td style="text-align: left"><span class='requdIndicator'>*</span></td>

						<td><app:select items="${allServiceTypes}"
								id="serviceTypeSelect"
								path="serviceParameters.voluntaryServiceType"
								itemLabel="name" itemValue="id" /> <app:errors
								path="serviceParameters.voluntaryServiceType"
								cssClass="msg-error" /></td>
					</tr>
					<tr>
						<td class='appFieldLabel'><label
							for='secPhoneId'>Alternate Phone:</label></td>
						<td></td>
						<td><app:input path="serviceParameters.secondaryPhone"
								id="secPhoneId" cssClass="phoneextmask" size="20" /> <app:errors
								path="serviceParameters.secondaryPhone" cssClass="msg-error" /></td>
					</tr>
					<tr>
						<td class='appFieldLabel' nowrap><label for='mailStopId'>Mail
								Stop:<span class="invisibleRequiredFor508">*</span>
						</label></td>
						<td style="text-align: left"><span class='requdIndicator'>*</span></td>
						<td><app:input size="11" maxlength="6" id="mailStopId"
								path="serviceParameters.mailStop" /> <app:errors
								path="serviceParameters.mailStop" cssClass="msg-error" /></td>
					</tr>
				</table>
			</div>
		</fieldset>
	</div>

	<div class="clearCenter serviceParamContainer">
		<fieldset>
			<legend>Program Manager's Immediate Supervisor</legend>
			<table align="left">
				<tr>
					<td class='appFieldLabel' nowrap><label for='chiefManager'>Name:</label></td>
					<td><app:input path="serviceParameters.chiefManager"
							id="chiefManager" size="45" maxlength="150" /> <app:errors
							path="serviceParameters.chiefManager" cssClass="msg-error" /></td>
				</tr>
				<tr>
					<td class='appFieldLabel' nowrap><label for='chiefTitle'>Title:</label></td>
					<td><app:input path="serviceParameters.chiefTitle"
							id="chiefTitle" size="50" maxlength="255" /> <app:errors
							path="serviceParameters.chiefTitle" cssClass="msg-error" /></td>
				</tr>
				<app:input path="serviceParameters.chiefUserName" id="chiefUserName"
					type="hidden" />
			</table>
			<c:if test="${not FORM_READ_ONLY}">
						<a style="margin-left:110px" class="buttonAnchor" id="searchButton"
							href="javascript:popupAppUserSearch('managerSearch')">Search</a>
					</c:if>
		</fieldset>
	</div>

	<div class="clearCenter serviceParamContainer">
		<div class="leftHalf">
			<fieldset>
				<legend>VAVS Information</legend>
				<table>
					<tr>
						<td rowspan="2" width="23px">&nbsp;</td>
						<td class='appFieldLabel' nowrap>VAVS Committee Established:<span
								class="invisibleRequiredFor508">*</span>
						</td>
						<td style="text-align: left"><span class='requdIndicator'>*</span></td>
						<td><label><form:radiobutton
								path="serviceParameters.isVAVSCommittee" value="True" />Yes</label> 
								<label><form:radiobutton
								path="serviceParameters.isVAVSCommittee" value="False" />No</label></td>
						<td><app:errors path="serviceParameters.isVAVSCommittee"
								cssClass="msg-error" /></td>
					</tr>
				</table>
				<table>
					<tr>
						<td class='appFieldLabel'><label
							for='lastReviewedInput'>VAVS Information Last Reviewed:</label></td>
						<td></td>
						<td><app:input id="lastReviewedInput" path="serviceParameters.lastUpdated"
								disabled="true" size="12" /> <app:errors
								path="serviceParameters.lastUpdated" cssClass="msg-error" /></td>
					</tr>
					<tr>
						<td class='appFieldLabel' nowrap>Update VAVS Last Reviewed
								Date:<span class="invisibleRequiredFor508">*</span>
						</td>
						<td style="text-align: left"><span class='requdIndicator'>*</span></td>

						<td><label><form:radiobutton path="changeLastReviewedDate"
								value="True" />Yes</label> <label><form:radiobutton
								path="changeLastReviewedDate" value="False" />No</label></td>
						<td><app:errors path="changeLastReviewedDate"
								cssClass="msg-error" /></td>
					</tr>
				</table>
			</fieldset>
		</div>

		<div class="rightHalf">
			<fieldset>
				<legend>Costs</legend>
				<table>
					<tr>
						<td class='appFieldLabel'><label
							for='operCostId'>Operating Costs $:</label></td>
						<td><app:input size="15" maxlength="9"
								path="serviceParameters.operatingCosts" cssClass="monetaryInput"
								id="operCostId" /> <app:errors
								path="serviceParameters.operatingCosts" cssClass="msg-error" /></td>
					</tr>
					<tr>
						<td class='appFieldLabel'><label
							for='staffCostId'>Staff Costs $:</label></td>
						<td><app:input size="15" maxlength="9"
								path="serviceParameters.staffCosts" cssClass="monetaryInput"
								id="staffCostId" /> <app:errors
								path="serviceParameters.staffCosts" cssClass="msg-error" /></td>
					</tr>
				</table>
			</fieldset>
		</div>
	</div>

	<div class="clearCenter serviceParamContainer centerContent">
		<c:if test="${not FORM_READ_ONLY}">
			<a class="buttonAnchor" id="submitFormButton" tabIndex="0">Submit</a>
		</c:if>
		<a id="cancelOperationBtn" class="buttonAnchor"
			href="${current_breadcrumb}">Cancel</a>
	</div>
</form:form>

<div class="clearCenter serviceParamContainer">
	<fieldset>
		<legend>VAVS Staff Members</legend>

		<div align="center">
			<c:if test="${not FORM_READ_ONLY}">
				<a class="buttonAnchor" id="createButton"
					href="javascript:showStaffDetailsPopup()">Add Staff</a>
			</c:if>
		</div>
		<table id="staffList" class="stripe"
			summary="List of Staff">
			<thead>
				<tr>
					<td class="noborder">Filters:</td>
					<td class="noborder"></td>
					<td class="noborder"></td>
					<td class="noborder"></td>
					<td class="noborder" id="initiatorFilter"
						title="Filter Staff by end date"></td>
					<td class="noborder"></td>
				</tr>
				<tr>
					<th width="15%">Name</th>
					<th width="30%">VAVS Role</th>
					<th width="15%">VAVS Leadership Board</th>
					<th width="15%">Start Date</th>
					<th width="15%" class="select-filter">End Date</th>
					<th width="10%">Action</th>
				</tr>
			</thead>
			<tbody>
			</tbody>
		</table>
	</fieldset>
</div>

<%@ include file="/WEB-INF/jsp/serviceParameters/serviceStaffDetail.jsp"%>

