<%@ include file="../shared/inc_header.jsp"%>

<script type="text/javascript">
	function getReportPathExtension() {
		return ""
	}

	setWidgetsInitializedCallback(function() {
		var stationWidget = getWidget('stationId')
		var organizationsWidget = getWidget('organizations')
		var nationalOrLocalWidget = getWidget('nationalOrLocalOrg')

		organizationsWidget.setRefreshParamProvider(function() {
			var nationOrLocal = nationalOrLocalWidget.getParameterValue()
			if (nationOrLocal == 'N') {
				return {
					includeLocal : "false",
					includeNational : "true",
				}
			} else {
				return {
					includeLocal : "true",
					includeNational : "false",
					stationId : stationWidget.getParameterValue(),
				}
			}
		})

		nationalOrLocalWidget.addValueUpdatedListener(function(evt,
				updatedReportParams) {
			var newVal = nationalOrLocalWidget.getParameterValue()

			var showNationalOrLocalDependentWidgets = newVal == 'L'
			stationWidget.toggle(showNationalOrLocalDependentWidgets)
			organizationsWidget.toggle(!showNationalOrLocalDependentWidgets || stationWidget.getParameterValue()!= '-1' )
			organizationsWidget.refresh()
		})

		stationWidget
				.addValueUpdatedListener(function(evt, updatedReportParams) {
					var newVal = stationWidget.getParameterValue()
					var showStationDependentWidgets = newVal && newVal != ''
					organizationsWidget.toggle(showStationDependentWidgets)
					organizationsWidget.refresh()
				})

	})

	setPreSubmitCallback(function(finalReportParams) {

		if (getWidget('nationalOrLocalOrg').getParameterValue() == 'N') {
			finalReportParams['Facility'] = '-1'
		}

	})
	
	setPreValidationsCallback(function() {
	  var isNational = getWidget('nationalOrLocalOrg').getParameterValue() == 'N'
		if(!isNational  && getWidget('stationId').getParameterValue() == '-1') {
			return "Please select a facility."
		}
	})
</script>



<div
	style="display: inline-block; vertical-align: top; text-align: center; min-width: 250px;">
	<tiles:insertDefinition name="widgetRadioButtons">
		<tiles:putAttribute name="widgetId" value="nationalOrLocalOrg"
			cascade="true" />
		<tiles:putAttribute name="reportParamName" value="Scope" />
		<tiles:putAttribute name="displayLabel" value="Facility" />
		<tiles:putAttribute name="submitAsReportParameters" value="false" />
		<tiles:putListAttribute name="items" cascade="true">
			<tiles:addAttribute value="National|N" />
			<tiles:addAttribute value="Local|L|Checked" />
		</tiles:putListAttribute>
	</tiles:insertDefinition>

	<tiles:insertDefinition name="widgetStationSelector">
		<tiles:putAttribute name="widgetId" value="stationId" cascade="true" />
		<tiles:putAttribute name="reportParamName" value="FacilityId" />
		<tiles:putAttribute name="displayLabel" value="Select Facility:" />
		<tiles:putAttribute name="bypassAsReportParameters" value="false"
			cascade="true" />
		<tiles:putAttribute name="showAllFacilities" value="false"
			cascade="true" />
		<tiles:putAttribute name="mode" value="single" cascade="true" />
	</tiles:insertDefinition>


	<%-- ====================================== Organization params =================================== --%>

	<tiles:insertDefinition name="widgetOrganizationSelector">
		<tiles:putAttribute name="widgetId" value="organizations"
			cascade="true" />
		<tiles:putAttribute name="reportParamName" value="OrganizationId" />
		<tiles:putAttribute name="displayLabel" value="Select Organization:" />
		<tiles:putAttribute name="includeLocal" value="true" cascade="true" />
		<tiles:putAttribute name="includeNational" value="false"
			cascade="true" />
		<tiles:putAttribute name="mode" value="single" cascade="true" />	
		<tiles:putAttribute name="bypassAsReportParameters" value="false" />
		<tiles:putAttribute name="initialVisibility" value="hidden" />
	</tiles:insertDefinition>

	<%-- ====================================== Date params =============================== --%>
	
	<tiles:insertDefinition name="widgetMonthYearInput">
		<tiles:putAttribute name="widgetId" value="beginDate" cascade="true" />
		<tiles:putAttribute name="reportParamName" value="ReviewDate" />
		<tiles:putAttribute name="displayLabel" value="Date of Review (MM/YYYY)" />
		<tiles:putAttribute name="submitAsReportParameters" value="true" />
		<tiles:putAttribute name="textInputAttributes"
			value='style="width:110px"' cascade="true" />
	</tiles:insertDefinition>

	<!-- <tiles:insertDefinition name="widgetDateInput">
		<tiles:putAttribute name="widgetId" value="endDate" cascade="true" />
		<tiles:putAttribute name="reportParamName" value="BeginDate2" />
		<tiles:putAttribute name="displayLabel" value="Date of Review" />
		<tiles:putAttribute name="submitAsReportParameters" value="true" />
		<tiles:putAttribute name="textInputAttributes"
			value='style="width:110px"' cascade="true" />
		<tiles:putAttribute name="initialValue" cascade="true">
			<vss:localDate date="${currentDate}" pattern="${TWO_DIGIT_DATE_ONLY}" />
		</tiles:putAttribute>
	</tiles:insertDefinition>
	-->
</div>